/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageScaleChange
extends NetworkMessage {
    protected final Float scale;
    protected final String scaleAxis;

    public MessageScaleChange(UUID uuid, String scaleAxis, Float scale) {
        super(uuid);
        this.scale = scale;
        this.scaleAxis = scaleAxis;
    }

    public static MessageScaleChange decode(FriendlyByteBuf buffer) {
        return new MessageScaleChange(buffer.m_130259_(), buffer.m_130277_(), Float.valueOf(buffer.readFloat()));
    }

    public static void encode(MessageScaleChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130070_(message.getScaleAxis());
        buffer.writeFloat(message.getScale().floatValue());
    }

    public static void handle(MessageScaleChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageScaleChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageScaleChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            return;
        }
        String scaleAxis = message.getScaleAxis();
        if (scaleAxis == null || !scaleAxis.equals("x") && !scaleAxis.equals("y") && !scaleAxis.equals("z")) {
            log.error("Unknown scale axis {} request for UUID {} from {}", (Object)scaleAxis, (Object)uuid, (Object)serverPlayer);
            return;
        }
        Float scale = message.getScale();
        if (scale == null || scale.floatValue() < 0.1f || scale.floatValue() > 10.0f) {
            log.error("Invalid scale {} request for UUID {} from {}", (Object)scale, (Object)uuid, (Object)serverPlayer);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return;
        }
        ScaleData<?> scaleData = easyNPC.getEasyNPCScaleData();
        if (scaleData == null) {
            log.error("Invalid scale data for {} from {}", (Object)message, (Object)context);
            return;
        }
        switch (scaleAxis) {
            case "x": {
                scaleData.setScaleX(scale);
                break;
            }
            case "y": {
                scaleData.setScaleY(scale);
                break;
            }
            case "z": {
                scaleData.setScaleZ(scale);
                break;
            }
            default: {
                log.error("Unknown scale axis {} request for UUID {} from {}", (Object)scaleAxis, (Object)uuid, (Object)serverPlayer);
            }
        }
    }

    public Float getScale() {
        return this.scale;
    }

    public String getScaleAxis() {
        return this.scaleAxis;
    }
}

