/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingData;
import de.markusbordihn.easynpc.network.NetworkMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageTradingTypeChange
extends NetworkMessage {
    protected final TradingType tradingType;

    public MessageTradingTypeChange(UUID uuid, TradingType tradingType) {
        super(uuid);
        this.tradingType = tradingType;
    }

    public static MessageTradingTypeChange decode(FriendlyByteBuf buffer) {
        return new MessageTradingTypeChange(buffer.m_130259_(), (TradingType)buffer.m_130066_(TradingType.class));
    }

    public static void encode(MessageTradingTypeChange message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.uuid);
        buffer.m_130068_((Enum)message.getTradingType());
    }

    public static void handle(MessageTradingTypeChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageTradingTypeChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageTradingTypeChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        TradingType tradingType = message.getTradingType();
        UUID uuid = message.getUUID();
        if (serverPlayer == null || tradingType == null || !NetworkMessage.checkAccess(uuid, serverPlayer)) {
            log.error("Unable to change trading type with message {} from {}", (Object)message, (Object)context);
            return;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        TradingData<?> tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            log.error("Invalid trading data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change trading type: {} for {} from {}", (Object)tradingType, easyNPC, (Object)serverPlayer);
        tradingData.setTradingType(tradingType);
    }

    public TradingType getTradingType() {
        return this.tradingType;
    }
}

