/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;

public class TextUtils {
    private TextUtils() {
    }

    public static Component normalizeName(String name) {
        return new TextComponent(TextUtils.normalizeString(name));
    }

    public static String normalizeString(String string) {
        Object normalizedString = string.toLowerCase().replace("_", " ").replace("-", " ");
        normalizedString = ((String)normalizedString).substring(0, 1).toUpperCase() + ((String)normalizedString).substring(1);
        return normalizedString;
    }

    public static String normalizeString(String string, int maxSize) {
        return TextUtils.limitString(TextUtils.normalizeString(string), maxSize);
    }

    public static String limitString(String string, int maxSize) {
        if (string == null || string.isBlank()) {
            return string;
        }
        String trimmedString = string.trim();
        int stringLength = trimmedString.length();
        if (stringLength <= maxSize) {
            return trimmedString;
        }
        return trimmedString.substring(0, maxSize) + "\u2026";
    }

    public static Component removeAction(Component component) {
        MutableComponent mutableComponent = component.m_6879_().m_6270_(component.m_7383_().m_131142_(null));
        for (Component componentSibling : component.m_7360_()) {
            mutableComponent.m_7220_(TextUtils.removeAction(componentSibling));
        }
        return mutableComponent;
    }
}

