/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.silkvoid.block;

import net.mcreator.silkvoid.init.SilkVoidModBlocks;
import net.mcreator.silkvoid.procedures.CrystalBundleMobplayerCollidesWithPlantProcedure;
import net.mcreator.silkvoid.procedures.CrystalBundlePlantDestroyedByExplosionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class CrystalBundleBlock
extends FlowerBlock {
    public CrystalBundleBlock(BlockBehaviour.Properties properties) {
        super(MobEffects.MOVEMENT_SPEED, 100.0f, properties.mapColor(MapColor.PLANT).sound(SoundType.AMETHYST_CLUSTER).strength(1.0f, 1.0f).hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).lightLevel(s -> 5).noCollission().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return groundState.is((Block)SilkVoidModBlocks.CRYSTAL_PEAKS_CRYSTAL.get());
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.entityInside(blockstate, world, pos, entity);
        CrystalBundleMobplayerCollidesWithPlantProcedure.execute((LevelAccessor)world, entity);
    }

    public void wasExploded(ServerLevel world, BlockPos pos, Explosion e) {
        super.wasExploded(world, pos, e);
        CrystalBundlePlantDestroyedByExplosionProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

