/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.silkvoid.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class EdgeShellBlock
extends FallingBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final MapCodec<EdgeShellBlock> CODEC = EdgeShellBlock.simpleCodec(EdgeShellBlock::new);

    public MapCodec<EdgeShellBlock> codec() {
        return CODEC;
    }

    public EdgeShellBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f).requiresCorrectToolForDrops());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.Y));
    }

    public int getLightBlock(BlockState state) {
        return 15;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(AXIS, (Comparable)context.getClickedFace().getAxis());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return RotatedPillarBlock.rotatePillar((BlockState)state, (Rotation)rot);
    }
}

