/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.silkvoid.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelBoofly
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"silk__void", (String)"model_boofly"), "main");
    public final ModelPart bodyPart_2;
    public final ModelPart wings1;
    public final ModelPart wings2;
    public final ModelPart bodyPart_1;
    public final ModelPart bodyPart_4;

    public ModelBoofly(ModelPart root) {
        super(root);
        this.bodyPart_2 = root.getChild("bodyPart_2");
        this.wings1 = this.bodyPart_2.getChild("wings1");
        this.wings2 = this.bodyPart_2.getChild("wings2");
        this.bodyPart_1 = this.bodyPart_2.getChild("bodyPart_1");
        this.bodyPart_4 = this.bodyPart_2.getChild("bodyPart_4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bodyPart_2 = partdefinition.addOrReplaceChild("bodyPart_2", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, 0.0f, -1.5f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)1.0f));
        PartDefinition wings1 = bodyPart_2.addOrReplaceChild("wings1", CubeListBuilder.create().texOffs(0, 11).addBox(0.0f, -3.5f, -3.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.5f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition wings2 = bodyPart_2.addOrReplaceChild("wings2", CubeListBuilder.create().texOffs(12, 11).addBox(0.0f, -3.5f, -3.0f, 0.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.5f, (float)1.5f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition bodyPart_1 = bodyPart_2.addOrReplaceChild("bodyPart_1", CubeListBuilder.create().texOffs(0, 20).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(24, 3).addBox(-2.0f, -2.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 5).addBox(1.0f, -2.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.5f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bodyPart_4 = bodyPart_2.addOrReplaceChild("bodyPart_4", CubeListBuilder.create().texOffs(14, 20).addBox(-1.0f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-0.5f, 0.5f, 1.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)2.0f, (float)4.5f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.wings2.zRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.wings1.zRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.bodyPart_1.yRot = netHeadYaw / 57.295776f;
        this.bodyPart_1.xRot = headPitch / 57.295776f;
        this.bodyPart_4.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
    }
}

