/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.silkvoid.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelSoulMaster
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"silk__void", (String)"model_soul_master"), "main");
    public final ModelPart Body;
    public final ModelPart RLeg1;
    public final ModelPart RLeg2;
    public final ModelPart LLeg1;
    public final ModelPart LLeg2;
    public final ModelPart Head;

    public ModelSoulMaster(ModelPart root) {
        super(root);
        this.Body = root.getChild("Body");
        this.RLeg1 = this.Body.getChild("RLeg1");
        this.RLeg2 = this.Body.getChild("RLeg2");
        this.LLeg1 = this.Body.getChild("LLeg1");
        this.LLeg2 = this.Body.getChild("LLeg2");
        this.Head = this.Body.getChild("Head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 40).addBox(-8.0f, 8.9167f, -4.9167f, 16.0f, 14.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(60, 78).addBox(-8.5f, 7.9167f, -5.4167f, 17.0f, 14.0f, 17.0f, new CubeDeformation(0.0f)).texOffs(5, 76).addBox(-7.0f, 8.9167f, -2.9167f, 14.0f, 18.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.9167f, (float)-3.0833f));
        PartDefinition cube_r1 = Body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(19, 43).addBox(-4.0f, -7.0f, -8.0f, 8.0f, 14.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)24.9167f, (float)4.0833f, (float)2.9671f, (float)0.0f, (float)2.9671f));
        PartDefinition cube_r2 = Body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(19, 43).addBox(-4.0f, -7.0f, -5.0f, 8.0f, 14.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)24.9167f, (float)4.0833f, (float)0.1745f, (float)0.0f, (float)0.1745f));
        PartDefinition RLeg1 = Body.addOrReplaceChild("RLeg1", CubeListBuilder.create().texOffs(34, 86).addBox(-1.0f, -7.5f, -1.0f, 2.0f, 13.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)26.4167f, (float)0.0833f));
        PartDefinition RLeg2 = Body.addOrReplaceChild("RLeg2", CubeListBuilder.create().texOffs(34, 86).addBox(-1.0f, -5.5f, -1.0f, 2.0f, 13.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)26.4167f, (float)5.0833f));
        PartDefinition LLeg1 = Body.addOrReplaceChild("LLeg1", CubeListBuilder.create().texOffs(34, 86).addBox(-1.0f, -7.5f, -1.0f, 2.0f, 13.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)26.4167f, (float)0.0833f));
        PartDefinition LLeg2 = Body.addOrReplaceChild("LLeg2", CubeListBuilder.create().texOffs(34, 86).addBox(-1.0f, -5.5f, -1.0f, 2.0f, 13.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)26.4167f, (float)5.0833f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -11.4088f, -5.7228f, 14.0f, 14.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(20, 28).addBox(-2.0f, -12.4088f, -6.7228f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.3255f, (float)1.8061f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = Head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(20, 28).addBox(-2.0f, -1.5f, -1.5f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-10.9088f, (float)-3.2228f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cube_r4 = Head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(12, 50).addBox(-6.0f, -16.0f, 1.0f, 3.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(9, 48).addBox(-7.0f, -14.0f, 0.0f, 15.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)1.5912f, (float)0.2772f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = Head.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 28).addBox(-2.5f, -3.0f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-7.4088f, (float)-3.4728f, (float)-1.5708f, (float)0.0f, (float)1.5708f));
        PartDefinition cube_r6 = Head.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(0, 28).addBox(-2.5f, -3.0f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-7.4088f, (float)-3.2228f, (float)-1.5708f, (float)0.0f, (float)-1.5708f));
        PartDefinition cube_r7 = Head.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(20, 28).addBox(-2.0f, -1.5f, -1.5f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-10.9088f, (float)-3.2228f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cube_r8 = Head.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(12, 50).addBox(-1.5f, -2.0f, -3.0f, 3.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-12.0069f, (float)5.4822f, (float)-3.0543f, (float)0.0f, (float)-3.1416f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.RLeg2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.RLeg1.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        this.LLeg2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.LLeg1.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.Body.xRot = Mth.sin((float)(ageInTicks * 0.6f)) * 0.6f;
    }
}

