/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.silkvoid.entity;

import java.util.EnumSet;
import net.mcreator.silkvoid.init.SilkVoidModEntities;
import net.mcreator.silkvoid.init.SilkVoidModItems;
import net.mcreator.silkvoid.procedures.BaldurDisplayCondition2Procedure;
import net.mcreator.silkvoid.procedures.PlayerCollidesIsHurtProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class ChargedLumaflyEntity
extends Monster {
    public ChargedLumaflyEntity(EntityType<ChargedLumaflyEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)SilkVoidModItems.GEO.get()));
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)SilkVoidModItems.GEO.get()));
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)SilkVoidModItems.GEO.get()));
        this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)SilkVoidModItems.GEO.get()));
        this.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)SilkVoidModItems.GEO.get()));
        this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)SilkVoidModItems.GEO.get()));
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(3, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                return ChargedLumaflyEntity.this.getTarget() != null && !ChargedLumaflyEntity.this.getMoveControl().hasWanted();
            }

            public boolean canContinueToUse() {
                return ChargedLumaflyEntity.this.getMoveControl().hasWanted() && ChargedLumaflyEntity.this.getTarget() != null && ChargedLumaflyEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = ChargedLumaflyEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                ChargedLumaflyEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.0);
            }

            public void tick() {
                LivingEntity livingentity = ChargedLumaflyEntity.this.getTarget();
                if (ChargedLumaflyEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    ChargedLumaflyEntity.this.doHurtTarget(1.getServerLevel((Entity)livingentity), (Entity)livingentity);
                } else {
                    double d0 = ChargedLumaflyEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        ChargedLumaflyEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.0);
                    }
                }
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20){

            protected Vec3 getPosition() {
                RandomSource random = ChargedLumaflyEntity.this.getRandom();
                double dir_x = ChargedLumaflyEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = ChargedLumaflyEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = ChargedLumaflyEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)SilkVoidModItems.GEO.get()));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"silk__void:hero_hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"silk__void:husk_death"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        ChargedLumaflyEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        if (!BaldurDisplayCondition2Procedure.execute((Entity)entity)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public void playerTouch(Player sourceentity) {
        super.playerTouch(sourceentity);
        PlayerCollidesIsHurtProcedure.execute((LevelAccessor)this.level(), (Entity)sourceentity);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)SilkVoidModEntities.CHARGED_LUMAFLY.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos).is(Blocks.WATER) && world.getBlockState(pos.above()).is(Blocks.WATER), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 1.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.FLYING_SPEED, 0.3);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.3);
        return builder;
    }
}

