/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.silkvoid.entity;

import net.mcreator.silkvoid.entity.ElderBaldurEntityProjectile;
import net.mcreator.silkvoid.init.SilkVoidModEntities;
import net.mcreator.silkvoid.init.SilkVoidModItems;
import net.mcreator.silkvoid.procedures.BaldurNaturalEntitySpawningConditionProcedure;
import net.mcreator.silkvoid.procedures.BaldurOnEntityTickUpdateProcedure;
import net.mcreator.silkvoid.procedures.ElderBaldurEntityDiesProcedure;
import net.mcreator.silkvoid.procedures.ElderBaldurScaleProcedure;
import net.mcreator.silkvoid.procedures.InfectedEntityIsHurtProcedure;
import net.mcreator.silkvoid.procedures.PlayerCollidesIsHurtProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class ElderBaldurEntity
extends Monster
implements RangedAttackMob {
    public ElderBaldurEntity(EntityType<ElderBaldurEntity> type, Level world) {
        super(type, world);
        this.xpReward = 20;
        this.setNoAi(false);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)SilkVoidModItems.GEO_2.get()));
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)SilkVoidModItems.GEO_2.get()));
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)SilkVoidModItems.GEO_1.get()));
        this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)SilkVoidModItems.GEO_2.get()));
        this.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)SilkVoidModItems.GEO_1.get()));
        this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)SilkVoidModItems.GEO_1.get()));
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.goalSelector.addGoal(4, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 20, 10.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)SilkVoidModItems.GEO_2.get()));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.husk.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"silk__void:hero_hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"silk__void:husk_death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        ElderBaldurEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        InfectedEntityIsHurtProcedure.execute((LevelAccessor)world, x, y, z);
        return super.hurtServer(level, damagesource, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        ElderBaldurEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void baseTick() {
        super.baseTick();
        BaldurOnEntityTickUpdateProcedure.execute((Entity)this);
        this.refreshDimensions();
    }

    public void playerTouch(Player sourceentity) {
        super.playerTouch(sourceentity);
        PlayerCollidesIsHurtProcedure.execute((LevelAccessor)this.level(), (Entity)sourceentity);
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        ElderBaldurEntityProjectile entityarrow = new ElderBaldurEntityProjectile((EntityType<? extends ElderBaldurEntityProjectile>)((EntityType)SilkVoidModEntities.ELDER_BALDUR_PROJECTILE.get()), (LivingEntity)this, this.level());
        double d0 = target.getY() + (double)target.getEyeHeight() - 1.1;
        double d1 = target.getX() - this.getX();
        double d3 = target.getZ() - this.getZ();
        entityarrow.shoot(d1, d0 - entityarrow.getY() + Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f, d3, 1.6f, 12.0f);
        this.level().addFreshEntity((Entity)entityarrow);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        ElderBaldurEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)ElderBaldurScaleProcedure.execute((LevelAccessor)world, x, y, z));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)SilkVoidModEntities.ELDER_BALDUR.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return BaldurNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 70.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

