/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.silkvoid.entity;

import javax.annotation.Nullable;
import net.mcreator.silkvoid.init.SilkVoidModEntities;
import net.mcreator.silkvoid.init.SilkVoidModItems;
import net.mcreator.silkvoid.procedures.PlayerCollidesIsHurtProcedure;
import net.mcreator.silkvoid.procedures.ShadowEntityDiesProcedure;
import net.mcreator.silkvoid.procedures.VesselOnInitialEntitySpawnProcedure;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class VesselShadowEntity
extends Monster {
    public VesselShadowEntity(EntityType<VesselShadowEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)SilkVoidModItems.CRAFTMETAL_NEEDLE.get()));
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)SilkVoidModItems.GEO.get()));
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)SilkVoidModItems.GEO_1.get()));
        this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)SilkVoidModItems.GEO.get()));
        this.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)SilkVoidModItems.GEO.get()));
        this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)SilkVoidModItems.GEO.get()));
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (VesselShadowEntity.this.isInWater()) {
                    VesselShadowEntity.this.setDeltaMovement(VesselShadowEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !VesselShadowEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - VesselShadowEntity.this.getX();
                    double dy = this.wantedY - VesselShadowEntity.this.getY();
                    double dz = this.wantedZ - VesselShadowEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * VesselShadowEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    VesselShadowEntity.this.setYRot(this.rotlerp(VesselShadowEntity.this.getYRot(), f, 10.0f));
                    VesselShadowEntity.this.yBodyRot = VesselShadowEntity.this.getYRot();
                    VesselShadowEntity.this.yHeadRot = VesselShadowEntity.this.getYRot();
                    if (VesselShadowEntity.this.isInWater()) {
                        VesselShadowEntity.this.setSpeed((float)VesselShadowEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        VesselShadowEntity.this.setXRot(this.rotlerp(VesselShadowEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(VesselShadowEntity.this.getXRot() * ((float)Math.PI / 180)));
                        VesselShadowEntity.this.setZza(f3 * f1);
                        VesselShadowEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        VesselShadowEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    VesselShadowEntity.this.setSpeed(0.0f);
                    VesselShadowEntity.this.setYya(0.0f);
                    VesselShadowEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.5, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.goalSelector.addGoal(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)SilkVoidModItems.GEO.get()));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        ShadowEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        VesselOnInitialEntitySpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void playerTouch(Player sourceentity) {
        super.playerTouch(sourceentity);
        PlayerCollidesIsHurtProcedure.execute((LevelAccessor)this.level(), (Entity)sourceentity);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        VesselShadowEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        VesselShadowEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)SilkVoidModEntities.VESSEL_SHADOW.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos).is(Blocks.WATER) && world.getBlockState(pos.above()).is(Blocks.WATER), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.3);
        return builder;
    }
}

