/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.silkvoid.potion;

import java.util.ArrayList;
import net.mcreator.silkvoid.init.SilkVoidModMobEffects;
import net.mcreator.silkvoid.init.SilkVoidModParticleTypes;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.RemoveStatusEffectsConsumeEffect;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class VoidGraspMobEffect
extends MobEffect {
    public VoidGraspMobEffect() {
        super(MobEffectCategory.HARMFUL, -16777216, mobEffectInstance -> (SimpleParticleType)SilkVoidModParticleTypes.VOID_PARTICLE.get());
        this.addAttributeModifier(Attributes.ARMOR, ResourceLocation.fromNamespaceAndPath((String)"silk__void", (String)"effect.void_grasp_0"), -5.0, AttributeModifier.Operation.ADD_VALUE);
        this.addAttributeModifier(Attributes.ATTACK_SPEED, ResourceLocation.fromNamespaceAndPath((String)"silk__void", (String)"effect.void_grasp_1"), -5.0, AttributeModifier.Operation.ADD_VALUE);
        this.addAttributeModifier(Attributes.GRAVITY, ResourceLocation.fromNamespaceAndPath((String)"silk__void", (String)"effect.void_grasp_2"), 5.0, AttributeModifier.Operation.ADD_VALUE);
        this.addAttributeModifier(Attributes.OXYGEN_BONUS, ResourceLocation.fromNamespaceAndPath((String)"silk__void", (String)"effect.void_grasp_3"), -5.0, AttributeModifier.Operation.ADD_VALUE);
        this.addAttributeModifier(NeoForgeMod.SWIM_SPEED, ResourceLocation.fromNamespaceAndPath((String)"silk__void", (String)"effect.void_grasp_4"), -5.0, AttributeModifier.Operation.ADD_VALUE);
    }

    @SubscribeEvent
    public static void modifyItemComponents(ModifyDefaultComponentsEvent event) {
        Consumable original = (Consumable)Items.HONEY_BOTTLE.components().get(DataComponents.CONSUMABLE);
        if (original != null) {
            ArrayList<RemoveStatusEffectsConsumeEffect> onConsumeEffects = new ArrayList<RemoveStatusEffectsConsumeEffect>(original.onConsumeEffects());
            onConsumeEffects.add(new RemoveStatusEffectsConsumeEffect(SilkVoidModMobEffects.VOID_GRASP));
            Consumable replacementConsumable = new Consumable(original.consumeSeconds(), original.animation(), original.sound(), original.hasConsumeParticles(), onConsumeEffects);
            event.modify((ItemLike)Items.HONEY_BOTTLE, builder -> builder.set(DataComponents.CONSUMABLE, (Object)replacementConsumable));
        }
    }
}

