/*
 * Decompiled with CFR 0.152.
 */
package org.calfmolten.hudier;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import org.calfmolten.hudier.HudierConfig;
import org.joml.Quaternionf;

public class Hudier {
    public static final String MOD_ID = "hudier";
    public static final KeyMapping TOGGLE_KEY = new KeyMapping("key.hudier.toggle", InputConstants.Type.KEYSYM, 72, "category.hudier.main");

    public static void init() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Hudier::registerClientEvents);
    }

    public static void registerClientEvents() {
        HudierConfig.load();
        KeyMappingRegistry.register((KeyMapping)TOGGLE_KEY);
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            while (TOGGLE_KEY.consumeClick()) {
                HudierConfig.instance.showHud = !HudierConfig.instance.showHud;
                HudierConfig.save();
            }
        });
        ClientGuiEvent.RENDER_HUD.register((guiGraphics, tickDelta) -> {
            Minecraft client = Minecraft.getInstance();
            if (client.player != null && !client.options.hideGui && HudierConfig.instance.showHud) {
                Hudier.renderFullHud(guiGraphics, client);
            }
        });
    }

    public static void renderFullHud(GuiGraphics guiGraphics, Minecraft client) {
        Holder biomeHolder;
        Optional keyOptional;
        HudierConfig config = HudierConfig.instance;
        int x = config.hudX;
        int y = config.hudY;
        int width = 90;
        int height = 130;
        guiGraphics.fill(x, y, x + width, y + height, config.backgroundColor);
        int textX = x + 5;
        int textY = y + 5;
        int lineHeight = 10;
        if (config.showState) {
            String stateKey = Hudier.getPlayerState(client);
            MutableComponent text = Component.translatable((String)"hudier.label.state").append(": ").append((Component)Component.translatable((String)stateKey));
            guiGraphics.drawString(client.font, (Component)text, textX, textY, 0xFFFFFF, true);
        }
        int dollY = y + 80;
        int dollX = x + width / 2;
        Hudier.renderCustomPaperDoll(guiGraphics, client, dollX, dollY, config.scale);
        int infoY = dollY + 10;
        if (config.showDay) {
            long dayCount = client.level.getGameTime() / 24000L + 1L;
            guiGraphics.drawString(client.font, (Component)Component.translatable((String)"hudier.label.day", (Object[])new Object[]{dayCount}), textX, infoY, 0xFFAA00, true);
            infoY += lineHeight;
        }
        if (config.showTime) {
            String timeString = Hudier.formatGameTime((Level)client.level);
            MutableComponent text = Component.translatable((String)"hudier.label.time").append(": ").append(timeString);
            guiGraphics.drawString(client.font, (Component)text, textX, infoY, 43690, true);
            infoY += lineHeight;
        }
        if (config.showBiome && client.level != null && (keyOptional = (biomeHolder = client.level.getBiome(client.player.blockPosition())).unwrapKey()).isPresent()) {
            ResourceKey key = (ResourceKey)keyOptional.get();
            String translationKey = "biome." + key.location().getNamespace() + "." + key.location().getPath();
            Object biomeName = Component.translatable((String)translationKey).getString();
            if (((String)biomeName).length() > 14) {
                biomeName = ((String)biomeName).substring(0, 14) + ".";
            }
            MutableComponent text = Component.translatable((String)"hudier.label.biome").append(": ").append((String)biomeName);
            guiGraphics.drawString(client.font, (Component)text, textX, infoY, 0x55FF55, true);
        }
    }

    private static String formatGameTime(Level level) {
        long time = level.getDayTime();
        int hours = (int)((time / 1000L + 6L) % 24L);
        int minutes = (int)(time % 1000L * 60L / 1000L);
        return String.format("%02d:%02d", hours, minutes);
    }

    private static String getPlayerState(Minecraft client) {
        if (client.player.isSleeping()) {
            return "hudier.state.sleeping";
        }
        if (client.player.isPassenger()) {
            Entity vehicle = client.player.getVehicle();
            if (vehicle instanceof Boat) {
                return "hudier.state.boating";
            }
            if (vehicle instanceof AbstractMinecart) {
                return "hudier.state.minecart";
            }
            if (vehicle instanceof Horse) {
                return "hudier.state.riding_horse";
            }
            if (vehicle instanceof Donkey) {
                return "hudier.state.riding_donkey";
            }
            if (vehicle instanceof Mule) {
                return "hudier.state.riding_mule";
            }
            if (vehicle instanceof Camel) {
                return "hudier.state.riding_camel";
            }
            if (vehicle instanceof Pig) {
                return "hudier.state.riding_pig";
            }
            if (vehicle instanceof Strider) {
                return "hudier.state.riding_strider";
            }
            if (vehicle instanceof SkeletonHorse) {
                return "hudier.state.riding_skeleton_horse";
            }
            if (vehicle instanceof ZombieHorse) {
                return "hudier.state.riding_zombie_horse";
            }
            return "hudier.state.riding";
        }
        if (client.player.isFallFlying()) {
            return "hudier.state.flying";
        }
        if (client.player.isSwimming()) {
            return "hudier.state.swimming";
        }
        if (client.player.isVisuallyCrawling()) {
            return "hudier.state.crawling";
        }
        if (client.player.isCrouching()) {
            return "hudier.state.crouching";
        }
        if (client.player.isSprinting()) {
            return "hudier.state.sprinting";
        }
        if (client.player.getDeltaMovement().lengthSqr() > 0.008) {
            return "hudier.state.walking";
        }
        return "hudier.state.idle";
    }

    public static void renderCustomPaperDoll(GuiGraphics guiGraphics, Minecraft client, int xPos, int yPos, int baseScale) {
        Entity entityToRender = client.player.getVehicle();
        int finalScale = baseScale;
        if (entityToRender == null) {
            entityToRender = client.player;
        } else {
            finalScale = (int)((double)baseScale * 0.75);
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)xPos, (double)yPos, 50.0);
        poseStack.scale((float)finalScale, (float)finalScale, (float)finalScale);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        Quaternionf rotation = new Quaternionf();
        rotation.rotateX((float)Math.toRadians(10.0));
        rotation.rotateY((float)Math.toRadians(125.0));
        poseStack.mulPose(rotation);
        RenderSystem.applyModelViewMatrix();
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityRenderDispatcher = client.getEntityRenderDispatcher();
        rotation.conjugate();
        entityRenderDispatcher.overrideCameraOrientation(rotation);
        entityRenderDispatcher.setRenderShadow(false);
        float originalYRot = entityToRender.getYRot();
        float originalXRot = entityToRender.getXRot();
        float originalYBodyRot = 0.0f;
        float originalYHeadRot = 0.0f;
        float originalYHeadRotO = 0.0f;
        float playerOriginalXRot = client.player.getXRot();
        float playerOriginalYBody = client.player.yBodyRot;
        float playerOriginalYHead = client.player.getYHeadRot();
        float playerOriginalYHeadO = client.player.yHeadRotO;
        float renderYaw = 150.0f;
        if (entityToRender instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entityToRender;
            originalYBodyRot = living.yBodyRot;
            originalYHeadRot = living.getYHeadRot();
            originalYHeadRotO = living.yHeadRotO;
            living.yBodyRot = renderYaw;
            living.setYHeadRot(renderYaw);
            living.yHeadRotO = renderYaw;
            living.setXRot(0.0f);
        } else {
            entityToRender.setYRot(renderYaw + 180.0f);
            entityToRender.setXRot(0.0f);
        }
        if (entityToRender != client.player) {
            client.player.yBodyRot = renderYaw;
            client.player.setYHeadRot(renderYaw);
            client.player.yHeadRotO = renderYaw;
            client.player.setXRot(0.0f);
        }
        MultiBufferSource.BufferSource bufferSource = client.renderBuffers().bufferSource();
        try {
            entityRenderDispatcher.render(entityToRender, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0);
            if (entityToRender.hasPassenger((Entity)client.player)) {
                double yOffset = Hudier.getRideHeight(entityToRender);
                entityRenderDispatcher.render((Entity)client.player, 0.0, yOffset, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        bufferSource.endBatch();
        entityRenderDispatcher.setRenderShadow(true);
        entityRenderDispatcher.overrideCameraOrientation(null);
        entityToRender.setYRot(originalYRot);
        entityToRender.setXRot(originalXRot);
        if (entityToRender instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entityToRender;
            living.yBodyRot = originalYBodyRot;
            living.setYHeadRot(originalYHeadRot);
            living.yHeadRotO = originalYHeadRotO;
        }
        if (entityToRender != client.player) {
            client.player.setXRot(playerOriginalXRot);
            client.player.yBodyRot = playerOriginalYBody;
            client.player.setYHeadRot(playerOriginalYHead);
            client.player.yHeadRotO = playerOriginalYHeadO;
        }
        poseStack.popPose();
        Lighting.setupFor3DItems();
    }

    private static double getRideHeight(Entity vehicle) {
        if (vehicle instanceof Camel) {
            return 1.45;
        }
        if (vehicle instanceof AbstractHorse) {
            return 0.85;
        }
        if (vehicle instanceof Pig) {
            return 0.45;
        }
        if (vehicle instanceof Strider) {
            return 0.55;
        }
        if (vehicle instanceof LivingEntity) {
            return 0.6;
        }
        return 0.0;
    }
}

