/*
 * Decompiled with CFR 0.152.
 */
package org.calfmolten.hudier;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.client.Minecraft;

public class HudierConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(Minecraft.getInstance().gameDirectory, "config/hudier.json");
    public static HudierConfig instance = new HudierConfig();
    public boolean showHud = true;
    public int hudX = 10;
    public int hudY = 10;
    public int scale = 30;
    public int backgroundColor = Integer.MIN_VALUE;
    public boolean showDay = true;
    public boolean showTime = true;
    public boolean showBiome = true;
    public boolean showState = true;

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                instance = (HudierConfig)GSON.fromJson((Reader)reader, HudierConfig.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            HudierConfig.save();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)instance, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

