/*
 * Decompiled with CFR 0.152.
 */
package org.calfmolten.hudier;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1452;
import net.minecraft.class_1495;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1500;
import net.minecraft.class_1506;
import net.minecraft.class_1507;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4985;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7689;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import org.calfmolten.hudier.HudierConfig;
import org.joml.Quaternionf;

public class Hudier {
    public static final String MOD_ID = "hudier";
    public static final class_304 TOGGLE_KEY = new class_304("key.hudier.toggle", class_3675.class_307.field_1668, 72, "category.hudier.main");

    public static void init() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Hudier::registerClientEvents);
    }

    public static void registerClientEvents() {
        HudierConfig.load();
        KeyMappingRegistry.register((class_304)TOGGLE_KEY);
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            while (TOGGLE_KEY.method_1436()) {
                HudierConfig.instance.showHud = !HudierConfig.instance.showHud;
                HudierConfig.save();
            }
        });
        ClientGuiEvent.RENDER_HUD.register((guiGraphics, tickDelta) -> {
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null && !client.field_1690.field_1842 && HudierConfig.instance.showHud) {
                Hudier.renderFullHud(guiGraphics, client);
            }
        });
    }

    public static void renderFullHud(class_332 guiGraphics, class_310 client) {
        class_6880 biomeHolder;
        Optional keyOptional;
        HudierConfig config = HudierConfig.instance;
        int x = config.hudX;
        int y = config.hudY;
        int width = 90;
        int height = 130;
        guiGraphics.method_25294(x, y, x + width, y + height, config.backgroundColor);
        int textX = x + 5;
        int textY = y + 5;
        int lineHeight = 10;
        if (config.showState) {
            String stateKey = Hudier.getPlayerState(client);
            class_5250 text = class_2561.method_43471((String)"hudier.label.state").method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)stateKey));
            guiGraphics.method_51439(client.field_1772, (class_2561)text, textX, textY, 0xFFFFFF, true);
        }
        int dollY = y + 80;
        int dollX = x + width / 2;
        Hudier.renderCustomPaperDoll(guiGraphics, client, dollX, dollY, config.scale);
        int infoY = dollY + 10;
        if (config.showDay) {
            long dayCount = client.field_1687.method_8510() / 24000L + 1L;
            guiGraphics.method_51439(client.field_1772, (class_2561)class_2561.method_43469((String)"hudier.label.day", (Object[])new Object[]{dayCount}), textX, infoY, 0xFFAA00, true);
            infoY += lineHeight;
        }
        if (config.showTime) {
            String timeString = Hudier.formatGameTime((class_1937)client.field_1687);
            class_5250 text = class_2561.method_43471((String)"hudier.label.time").method_27693(": ").method_27693(timeString);
            guiGraphics.method_51439(client.field_1772, (class_2561)text, textX, infoY, 43690, true);
            infoY += lineHeight;
        }
        if (config.showBiome && client.field_1687 != null && (keyOptional = (biomeHolder = client.field_1687.method_23753(client.field_1724.method_24515())).method_40230()).isPresent()) {
            class_5321 key = (class_5321)keyOptional.get();
            String translationKey = "biome." + key.method_29177().method_12836() + "." + key.method_29177().method_12832();
            Object biomeName = class_2561.method_43471((String)translationKey).getString();
            if (((String)biomeName).length() > 14) {
                biomeName = ((String)biomeName).substring(0, 14) + ".";
            }
            class_5250 text = class_2561.method_43471((String)"hudier.label.biome").method_27693(": ").method_27693((String)biomeName);
            guiGraphics.method_51439(client.field_1772, (class_2561)text, textX, infoY, 0x55FF55, true);
        }
    }

    private static String formatGameTime(class_1937 level) {
        long time = level.method_8532();
        int hours = (int)((time / 1000L + 6L) % 24L);
        int minutes = (int)(time % 1000L * 60L / 1000L);
        return String.format("%02d:%02d", hours, minutes);
    }

    private static String getPlayerState(class_310 client) {
        if (client.field_1724.method_6113()) {
            return "hudier.state.sleeping";
        }
        if (client.field_1724.method_5765()) {
            class_1297 vehicle = client.field_1724.method_5854();
            if (vehicle instanceof class_1690) {
                return "hudier.state.boating";
            }
            if (vehicle instanceof class_1688) {
                return "hudier.state.minecart";
            }
            if (vehicle instanceof class_1498) {
                return "hudier.state.riding_horse";
            }
            if (vehicle instanceof class_1495) {
                return "hudier.state.riding_donkey";
            }
            if (vehicle instanceof class_1500) {
                return "hudier.state.riding_mule";
            }
            if (vehicle instanceof class_7689) {
                return "hudier.state.riding_camel";
            }
            if (vehicle instanceof class_1452) {
                return "hudier.state.riding_pig";
            }
            if (vehicle instanceof class_4985) {
                return "hudier.state.riding_strider";
            }
            if (vehicle instanceof class_1506) {
                return "hudier.state.riding_skeleton_horse";
            }
            if (vehicle instanceof class_1507) {
                return "hudier.state.riding_zombie_horse";
            }
            return "hudier.state.riding";
        }
        if (client.field_1724.method_6128()) {
            return "hudier.state.flying";
        }
        if (client.field_1724.method_5681()) {
            return "hudier.state.swimming";
        }
        if (client.field_1724.method_20448()) {
            return "hudier.state.crawling";
        }
        if (client.field_1724.method_18276()) {
            return "hudier.state.crouching";
        }
        if (client.field_1724.method_5624()) {
            return "hudier.state.sprinting";
        }
        if (client.field_1724.method_18798().method_1027() > 0.008) {
            return "hudier.state.walking";
        }
        return "hudier.state.idle";
    }

    public static void renderCustomPaperDoll(class_332 guiGraphics, class_310 client, int xPos, int yPos, int baseScale) {
        class_1297 entityToRender = client.field_1724.method_5854();
        int finalScale = baseScale;
        if (entityToRender == null) {
            entityToRender = client.field_1724;
        } else {
            finalScale = (int)((double)baseScale * 0.75);
        }
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22904((double)xPos, (double)yPos, 50.0);
        poseStack.method_22905((float)finalScale, (float)finalScale, (float)finalScale);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        Quaternionf rotation = new Quaternionf();
        rotation.rotateX((float)Math.toRadians(10.0));
        rotation.rotateY((float)Math.toRadians(125.0));
        poseStack.method_22907(rotation);
        RenderSystem.applyModelViewMatrix();
        class_308.method_34742();
        class_898 entityRenderDispatcher = client.method_1561();
        rotation.conjugate();
        entityRenderDispatcher.method_24196(rotation);
        entityRenderDispatcher.method_3948(false);
        float originalYRot = entityToRender.method_36454();
        float originalXRot = entityToRender.method_36455();
        float originalYBodyRot = 0.0f;
        float originalYHeadRot = 0.0f;
        float originalYHeadRotO = 0.0f;
        float playerOriginalXRot = client.field_1724.method_36455();
        float playerOriginalYBody = client.field_1724.field_6283;
        float playerOriginalYHead = client.field_1724.method_5791();
        float playerOriginalYHeadO = client.field_1724.field_6259;
        float renderYaw = 150.0f;
        if (entityToRender instanceof class_1309) {
            class_1309 living = (class_1309)entityToRender;
            originalYBodyRot = living.field_6283;
            originalYHeadRot = living.method_5791();
            originalYHeadRotO = living.field_6259;
            living.field_6283 = renderYaw;
            living.method_5847(renderYaw);
            living.field_6259 = renderYaw;
            living.method_36457(0.0f);
        } else {
            entityToRender.method_36456(renderYaw + 180.0f);
            entityToRender.method_36457(0.0f);
        }
        if (entityToRender != client.field_1724) {
            client.field_1724.field_6283 = renderYaw;
            client.field_1724.method_5847(renderYaw);
            client.field_1724.field_6259 = renderYaw;
            client.field_1724.method_36457(0.0f);
        }
        class_4597.class_4598 bufferSource = client.method_22940().method_23000();
        try {
            entityRenderDispatcher.method_3954(entityToRender, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (class_4597)bufferSource, 0xF000F0);
            if (entityToRender.method_5626((class_1297)client.field_1724)) {
                double yOffset = Hudier.getRideHeight(entityToRender);
                entityRenderDispatcher.method_3954((class_1297)client.field_1724, 0.0, yOffset, 0.0, 0.0f, 1.0f, poseStack, (class_4597)bufferSource, 0xF000F0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        bufferSource.method_22993();
        entityRenderDispatcher.method_3948(true);
        entityRenderDispatcher.method_24196(null);
        entityToRender.method_36456(originalYRot);
        entityToRender.method_36457(originalXRot);
        if (entityToRender instanceof class_1309) {
            class_1309 living = (class_1309)entityToRender;
            living.field_6283 = originalYBodyRot;
            living.method_5847(originalYHeadRot);
            living.field_6259 = originalYHeadRotO;
        }
        if (entityToRender != client.field_1724) {
            client.field_1724.method_36457(playerOriginalXRot);
            client.field_1724.field_6283 = playerOriginalYBody;
            client.field_1724.method_5847(playerOriginalYHead);
            client.field_1724.field_6259 = playerOriginalYHeadO;
        }
        poseStack.method_22909();
        class_308.method_24211();
    }

    private static double getRideHeight(class_1297 vehicle) {
        if (vehicle instanceof class_7689) {
            return 1.45;
        }
        if (vehicle instanceof class_1496) {
            return 0.85;
        }
        if (vehicle instanceof class_1452) {
            return 0.45;
        }
        if (vehicle instanceof class_4985) {
            return 0.55;
        }
        if (vehicle instanceof class_1309) {
            return 0.6;
        }
        return 0.0;
    }
}

