/*
 * Decompiled with CFR 0.152.
 */
package com.joseetoon.carcass.block;

import com.joseetoon.carcass.block.BlockCarcass;
import com.joseetoon.carcass.block.entity.ButchersBlockEntity;
import com.joseetoon.carcass.block.entity.CarcassBlockEntity;
import com.joseetoon.carcass.config.HuntingConfig;
import com.joseetoon.carcass.registry.CarcassParticles;
import com.joseetoon.carcass.util.KnifeStats;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BlockButchersBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = BlockButchersBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BlockButchersBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_60955_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ButchersBlockEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof ButchersBlockEntity) {
                ButchersBlockEntity butcher = (ButchersBlockEntity)be;
                Containers.m_18992_((Level)level, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)butcher.getCarcass());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        } else {
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        CarcassBlockEntity carcass;
        BlockEntity carcassBE;
        BlockPos above;
        BlockState aboveState;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack held = player.m_21120_(hand);
        if (held.m_41619_()) {
            return InteractionResult.PASS;
        }
        if ((held.m_41720_() instanceof SwordItem || held.m_41720_() instanceof TieredItem) && (aboveState = level.m_8055_(above = pos.m_7494_())).m_60734_() instanceof BlockCarcass && (carcassBE = level.m_7702_(above)) instanceof CarcassBlockEntity && (carcass = (CarcassBlockEntity)carcassBE).isKnife(held)) {
            if (((Boolean)HuntingConfig.ENABLE_PLAYER_ITEM_COOLDOWN.get()).booleanValue() && player.m_36335_().m_41519_(held.m_41720_())) {
                this.spawnCooldownFeedback(level, pos, player);
                return InteractionResult.CONSUME;
            }
            int cooldownTicks = KnifeStats.getCooldownTicks(held, player, true);
            long now = level.m_46467_();
            if (cooldownTicks > 0 && now < carcass.getCooldownUntilTick()) {
                this.applyRemainingItemCooldown(player, held, carcass.getCooldownUntilTick() - now);
                this.spawnCooldownFeedback(level, pos, player);
                return InteractionResult.CONSUME;
            }
            List<ItemStack> drops = carcass.processKnife(held, player, true);
            if (!drops.isEmpty()) {
                int playerCooldownTicks;
                for (ItemStack drop : drops) {
                    this.spawnSliceEffects(level, pos, drop);
                    if (player.m_36356_(drop)) continue;
                    player.m_36176_(drop, false);
                }
                if (carcass.isEmpty()) {
                    level.m_7471_(above, false);
                }
                if ((playerCooldownTicks = KnifeStats.getPlayerCooldownTicks(held, true)) > 0) {
                    System.out.println("  [BlockButchersBlock] Applying player item cooldown: " + playerCooldownTicks + " ticks");
                    player.m_36335_().m_41524_(held.m_41720_(), playerCooldownTicks);
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void spawnSliceEffects(Level level, BlockPos pos, ItemStack drop) {
        if (((Boolean)HuntingConfig.SLICE_SOUND_ENABLED.get()).booleanValue()) {
            float basePitch = 0.9f;
            float jitter = ((Double)HuntingConfig.SLICE_SOUND_PITCH_JITTER.get()).floatValue();
            float pitch = basePitch + level.m_213780_().m_188501_() * jitter;
            SoundEvent sound = this.chooseSound(drop);
            level.m_5594_(null, pos, sound, SoundSource.BLOCKS, ((Double)HuntingConfig.SLICE_SOUND_VOLUME.get()).floatValue(), pitch);
            level.m_5594_(null, pos, SoundEvents.f_12316_, SoundSource.BLOCKS, 0.4f, 0.8f + level.m_213780_().m_188501_() * 0.3f);
        }
        if (((Boolean)HuntingConfig.SLICE_PARTICLES_ENABLED.get()).booleanValue()) {
            int i;
            ServerLevel serverLevel;
            int count = (Integer)HuntingConfig.SLICE_PARTICLE_COUNT.get();
            double cx = (double)pos.m_123341_() + 0.5;
            double cy = (double)pos.m_123342_() + 1.1;
            double cz = (double)pos.m_123343_() + 0.5;
            Vector3f from = new Vector3f(0.8f, 0.1f, 0.1f);
            Vector3f to = new Vector3f(0.6f, 0.05f, 0.05f);
            Vector3f bloodFrom = new Vector3f(0.9f, 0.1f, 0.1f);
            Vector3f bloodTo = new Vector3f(0.4f, 0.0f, 0.0f);
            int bloodCount = Math.min(80, Math.max(12, count * 4));
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, cx, cy, cz, count, 0.12, 0.12, 0.12, 0.1);
                serverLevel.m_8767_((ParticleOptions)new DustColorTransitionOptions(from, to, 1.2f), cx, cy, cz, count, 0.06, 0.06, 0.06, 0.05);
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50005_.m_49966_()), cx, cy, cz, count, 0.04, 0.04, 0.04, 0.02);
                serverLevel.m_8767_((ParticleOptions)new DustColorTransitionOptions(bloodFrom, bloodTo, 1.6f), cx, cy, cz, bloodCount, 0.25, 0.2, 0.25, 0.2);
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50451_.m_49966_()), cx, cy, cz, bloodCount, 0.25, 0.2, 0.25, 0.1);
            } else {
                double vz;
                double vy;
                double vx;
                for (i = 0; i < count; ++i) {
                    vx = (level.m_213780_().m_188500_() - 0.5) * 0.12;
                    vy = level.m_213780_().m_188500_() * 0.12;
                    vz = (level.m_213780_().m_188500_() - 0.5) * 0.12;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123797_, cx, cy, cz, vx, vy, vz);
                    level.m_7106_((ParticleOptions)new DustColorTransitionOptions(from, to, 1.2f), cx, cy, cz, vx * 0.5, vy * 0.5, vz * 0.5);
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50005_.m_49966_()), cx, cy, cz, vx * 0.2, vy * 0.2, vz * 0.2);
                }
                for (i = 0; i < bloodCount; ++i) {
                    vx = (level.m_213780_().m_188500_() - 0.5) * 0.25;
                    vy = level.m_213780_().m_188500_() * 0.2;
                    vz = (level.m_213780_().m_188500_() - 0.5) * 0.25;
                    level.m_7106_((ParticleOptions)new DustColorTransitionOptions(bloodFrom, bloodTo, 1.6f), cx, cy, cz, vx, vy, vz);
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50451_.m_49966_()), cx, cy, cz, vx * 0.4, vy * 0.4, vz * 0.4);
                }
            }
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, cx, cy, cz, 3, 0.0, 0.0, 0.0, 0.0);
            } else {
                for (i = 0; i < 3; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123766_, cx, cy, cz, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private void applyRemainingItemCooldown(Player player, ItemStack held, long remainingTicks) {
        if (!((Boolean)HuntingConfig.ENABLE_PLAYER_ITEM_COOLDOWN.get()).booleanValue()) {
            return;
        }
        int ticks = (int)Math.min(Integer.MAX_VALUE, Math.max(0L, remainingTicks));
        if (ticks > 0) {
            player.m_36335_().m_41524_(held.m_41720_(), ticks);
        }
    }

    private SoundEvent chooseSound(ItemStack drop) {
        if (drop.m_204117_(Tags.Items.BONES)) {
            return SoundEvents.f_11708_;
        }
        if (drop.m_204117_(ItemTags.f_13167_) || drop.m_204117_(ItemTags.f_13143_)) {
            return SoundEvents.f_11992_;
        }
        return SoundEvents.f_12393_;
    }

    private void spawnCooldownFeedback(Level level, BlockPos pos, Player player) {
        System.out.println("[BlockButchersBlock] spawnCooldownFeedback called!");
        System.out.println("  Level: " + String.valueOf(level));
        System.out.println("  Is client side: " + level.f_46443_);
        System.out.println("  Position: " + String.valueOf(pos));
        if (level.f_46443_) {
            System.out.println("  Skipping - running on client side");
            return;
        }
        int messageIndex = (Boolean)HuntingConfig.ENABLE_RANDOM_COOLDOWN_MESSAGES.get() != false ? level.m_213780_().m_188503_(4) : -1;
        int messageColor = (Integer)HuntingConfig.COOLDOWN_MESSAGE_COLOR.get();
        System.out.println("  Message index: " + messageIndex);
        System.out.println("  Message color: 0x" + Integer.toHexString(messageColor));
        System.out.println("  Particle type: " + String.valueOf(CarcassParticles.COOLDOWN_MESSAGE.get()));
        double px = (double)pos.m_123341_() + 0.5;
        double py = (double)pos.m_123342_() + 1.2;
        double pz = (double)pos.m_123343_() + 0.5;
        System.out.println("  Spawning particle at: " + px + ", " + py + ", " + pz);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            System.out.println("  Using ServerLevel.sendParticles() - broadcasting to all nearby players");
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)CarcassParticles.COOLDOWN_MESSAGE.get()), px, py, pz, 0, (double)messageIndex, (double)messageColor, 0.0, 1.0);
            System.out.println("  Particle packet sent to clients!");
        } else {
            System.out.println("  ERROR: Level is not ServerLevel! Type: " + level.getClass().getName());
        }
        if (((Boolean)HuntingConfig.COOLDOWN_SOUND_ENABLED.get()).booleanValue()) {
            level.m_5594_(null, pos, SoundEvents.f_12315_, SoundSource.BLOCKS, ((Double)HuntingConfig.COOLDOWN_SOUND_VOLUME.get()).floatValue(), 0.7f + level.m_213780_().m_188501_() * 0.4f);
        }
        if (((Boolean)HuntingConfig.COOLDOWN_PARTICLES_ENABLED.get()).booleanValue()) {
            this.spawnFailureParticles(level, pos);
        }
    }

    private String getRandomCooldownMessage(Level level) {
        if (!((Boolean)HuntingConfig.ENABLE_RANDOM_COOLDOWN_MESSAGES.get()).booleanValue()) {
            return "message.carcass.carcass.cooldown";
        }
        String[] messages = new String[]{"message.carcass.carcass.miss", "message.carcass.carcass.wait", "message.carcass.carcass.too_fast", "message.carcass.carcass.hold_on"};
        return messages[level.m_213780_().m_188503_(messages.length)];
    }

    private void spawnFailureParticles(Level level, BlockPos pos) {
        double cx = (double)pos.m_123341_() + 0.5;
        double cy = (double)pos.m_123342_() + 1.1;
        double cz = (double)pos.m_123343_() + 0.5;
        Vector3f smokeFrom = new Vector3f(0.5f, 0.5f, 0.5f);
        Vector3f smokeTo = new Vector3f(0.3f, 0.3f, 0.3f);
        int count = (Integer)HuntingConfig.COOLDOWN_PARTICLE_COUNT.get();
        for (int i = 0; i < count; ++i) {
            double vx = (level.m_213780_().m_188500_() - 0.5) * 0.1;
            double vy = level.m_213780_().m_188500_() * 0.05;
            double vz = (level.m_213780_().m_188500_() - 0.5) * 0.1;
            level.m_7106_((ParticleOptions)new DustColorTransitionOptions(smokeFrom, smokeTo, 1.0f), cx, cy, cz, vx, vy, vz);
            if (i % 2 != 0) continue;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, cx, cy, cz, vx * 0.5, vy * 0.2, vz * 0.5);
        }
    }
}

