/*
 * Decompiled with CFR 0.152.
 */
package com.joseetoon.carcass.block.entity;

import com.joseetoon.carcass.block.entity.CarcassBlockEntity;
import com.joseetoon.carcass.registry.CarcassBlockEntities;
import com.joseetoon.carcass.util.KnifeStats;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ButchersBlockEntity
extends BlockEntity
implements Clearable {
    private ItemStack carcass = ItemStack.f_41583_;
    private NonNullList<ItemStack> contents = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);

    public ButchersBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CarcassBlockEntities.BUTCHERS_BLOCK.get(), pos, state);
    }

    public ItemStack getCarcass() {
        return this.carcass;
    }

    public ItemStack getPreviewDrop() {
        for (ItemStack stack : this.contents) {
            if (stack.m_41619_()) continue;
            return stack.m_255036_(1);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getLastDropPreview() {
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            ItemStack stack = (ItemStack)this.contents.get(i);
            if (stack.m_41619_()) continue;
            return stack.m_255036_(1);
        }
        return ItemStack.f_41583_;
    }

    public int getRemainingDropCount() {
        int count = 0;
        for (ItemStack stack : this.contents) {
            if (stack.m_41619_()) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public void setCarcass(ItemStack stack) {
        this.carcass = stack.m_41777_();
        this.contents = CarcassBlockEntity.readItemsFromStack(stack);
        this.m_6596_();
    }

    public boolean isKnife(ItemStack stack) {
        return KnifeStats.isHuntersKnife(stack);
    }

    public List<ItemStack> processKnife(ItemStack knife, Player player) {
        ItemStack drop;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.carcass.m_41619_() || this.f_58857_ == null) {
            return drops;
        }
        if (this.isContentsEmpty()) {
            this.carcass = ItemStack.f_41583_;
            this.m_6596_();
            return drops;
        }
        int extraSlices = KnifeStats.rollExtraSlices(knife, player, this.f_58857_.m_213780_());
        int slices = 1 + extraSlices;
        for (int i = 0; i < slices && !(drop = this.extractNext()).m_41619_(); ++i) {
            drops.add(drop);
            KnifeStats.damageKnife(knife, player);
            KnifeStats.applyExhaustion(player);
            if (knife.m_41619_() || this.isContentsEmpty()) break;
        }
        if (this.isContentsEmpty()) {
            this.carcass = ItemStack.f_41583_;
        }
        this.m_6596_();
        return drops;
    }

    private ItemStack extractNext() {
        for (int i = 0; i < this.contents.size(); ++i) {
            ItemStack stack = (ItemStack)this.contents.get(i);
            if (stack.m_41619_()) continue;
            ItemStack result = stack.m_41620_(1);
            if (stack.m_41619_()) {
                this.contents.set(i, (Object)ItemStack.f_41583_);
            }
            CarcassBlockEntity.writeItemsToStack(this.carcass, this.contents);
            return result;
        }
        return ItemStack.f_41583_;
    }

    private boolean isContentsEmpty() {
        for (ItemStack stack : this.contents) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Carcass", (Tag)this.carcass.m_41739_(new CompoundTag()));
        ContainerHelper.m_18976_((CompoundTag)tag, this.contents, (boolean)true);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.carcass = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Carcass"));
        this.contents = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.contents);
    }

    public void m_6211_() {
        this.carcass = ItemStack.f_41583_;
        this.contents.replaceAll(item -> ItemStack.f_41583_);
    }
}

