/*
 * Decompiled with CFR 0.152.
 */
package com.joseetoon.carcass.block.entity;

import com.joseetoon.carcass.registry.CarcassBlockEntities;
import com.joseetoon.carcass.util.KnifeStats;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CarcassBlockEntity
extends BlockEntity
implements Clearable {
    private static final String ITEMS_TAG = "Items";
    private static final String LAST_USE_TAG = "LastUse";
    private static final String COOLDOWN_UNTIL_TAG = "CooldownUntil";
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private long cooldownUntilTick = 0L;

    public CarcassBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CarcassBlockEntities.CARCASS.get(), pos, state);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack extractNextItem() {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_()) continue;
            ItemStack result = stack.m_41620_(1);
            if (stack.m_41619_()) {
                this.items.set(i, (Object)ItemStack.f_41583_);
            }
            this.m_6596_();
            return result;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getLastDropPreview() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_()) continue;
            return stack.m_255036_(1);
        }
        return ItemStack.f_41583_;
    }

    public int getRemainingDropCount() {
        int count = 0;
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public boolean isKnife(ItemStack stack) {
        return KnifeStats.isHuntersKnife(stack);
    }

    public long getCooldownUntilTick() {
        return this.cooldownUntilTick;
    }

    public List<ItemStack> processKnife(ItemStack knife, Player player, boolean onButcher) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.f_58857_ == null || this.isEmpty()) {
            System.out.println("[CarcassBlockEntity.processKnife] Level is null or carcass is empty");
            return drops;
        }
        int cooldown = KnifeStats.getCooldownTicks(knife, player, onButcher);
        long now = this.f_58857_.m_46467_();
        if (cooldown > 0 && now < this.cooldownUntilTick) {
            System.out.println("[CarcassBlockEntity.processKnife] Still in cooldown: " + (this.cooldownUntilTick - now) + " ticks remaining");
            return drops;
        }
        int extraSlices = KnifeStats.rollExtraSlices(knife, player, this.f_58857_.m_213780_());
        int slices = 1 + extraSlices;
        System.out.println("[CarcassBlockEntity.processKnife] ExtraSlices: " + extraSlices + ", Total slices: " + slices);
        for (int i = 0; i < slices; ++i) {
            ItemStack drop = this.extractNextItem();
            if (drop.m_41619_()) {
                System.out.println("[CarcassBlockEntity.processKnife] Carcass empty at slice " + (i + 1));
                break;
            }
            drops.add(drop);
            System.out.println("[CarcassBlockEntity.processKnife] Slice " + (i + 1) + ": dropped " + String.valueOf(drop));
            KnifeStats.damageKnife(knife, player);
            KnifeStats.applyExhaustion(player);
            if (!knife.m_41619_()) continue;
            System.out.println("[CarcassBlockEntity.processKnife] Knife broke at slice " + (i + 1));
            break;
        }
        System.out.println("[CarcassBlockEntity.processKnife] Total drops: " + drops.size());
        this.cooldownUntilTick = now + (long)Math.max(0, cooldown);
        this.m_6596_();
        return drops;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18976_((CompoundTag)tag, this.items, (boolean)true);
        tag.m_128356_(LAST_USE_TAG, this.cooldownUntilTick);
        tag.m_128356_(COOLDOWN_UNTIL_TAG, this.cooldownUntilTick);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128441_(COOLDOWN_UNTIL_TAG)) {
            this.cooldownUntilTick = tag.m_128454_(COOLDOWN_UNTIL_TAG);
        } else if (tag.m_128441_(LAST_USE_TAG)) {
            this.cooldownUntilTick = tag.m_128454_(LAST_USE_TAG);
        }
    }

    public void m_6211_() {
        this.items.clear();
    }

    public static NonNullList<ItemStack> readItemsFromStack(ItemStack stack) {
        NonNullList list = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && tag.m_128441_(ITEMS_TAG)) {
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)list);
        }
        return list;
    }

    public static long readLastUseFromStack(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && tag.m_128441_(LAST_USE_TAG)) {
            return tag.m_128454_(LAST_USE_TAG);
        }
        return 0L;
    }

    public static void writeItemsToStack(ItemStack stack, NonNullList<ItemStack> items) {
        CompoundTag blockEntityTag = stack.m_41698_("BlockEntityTag");
        ContainerHelper.m_18976_((CompoundTag)blockEntityTag, items, (boolean)true);
    }

    public static void writeLastUseToStack(ItemStack stack, long lastUse) {
        CompoundTag blockEntityTag = stack.m_41698_("BlockEntityTag");
        blockEntityTag.m_128356_(LAST_USE_TAG, lastUse);
    }

    public void populateFromItem(ItemStack stack) {
        NonNullList<ItemStack> loaded = CarcassBlockEntity.readItemsFromStack(stack);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)((ItemStack)loaded.get(i)));
        }
        this.cooldownUntilTick = CarcassBlockEntity.readLastUseFromStack(stack);
        this.m_6596_();
    }
}

