/*
 * Decompiled with CFR 0.152.
 */
package com.joseetoon.carcass.client;

import com.joseetoon.carcass.config.HuntingConfig;
import com.joseetoon.carcass.util.KnifeStats;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.DoubleFieldBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;

public final class HuntingClothConfigScreen {
    private HuntingClothConfigScreen() {
    }

    public static Screen create(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.m_237113_((String)"Carcass Hunting Config"));
        builder.setSavingRunnable(() -> {
            if (HuntingConfig.COMMON_CONFIG != null) {
                HuntingConfig.COMMON_CONFIG.save();
            }
            KnifeStats.invalidate();
        });
        ConfigEntryBuilder entry = builder.entryBuilder();
        ConfigCategory knives = builder.getOrCreateCategory((Component)Component.m_237113_((String)"Knives"));
        knives.addEntry((AbstractConfigListEntry)entry.startStrList((Component)Component.m_237113_((String)"Category Items"), HuntingClothConfigScreen.copyList((List)HuntingConfig.KNIFE_CATEGORY_ITEMS.get())).setDefaultValue(HuntingClothConfigScreen.copyList((List)HuntingConfig.KNIFE_CATEGORY_ITEMS.get())).setSaveConsumer(list -> HuntingConfig.KNIFE_CATEGORY_ITEMS.set(HuntingClothConfigScreen.copyList(list))).setTooltip(new Component[]{Component.m_237113_((String)"Format: category=modid:item,modid:item2 (new categories allowed)")}).build());
        knives.addEntry((AbstractConfigListEntry)entry.startStrList((Component)Component.m_237113_((String)"Category Cooldowns"), HuntingClothConfigScreen.copyList((List)HuntingConfig.KNIFE_CATEGORY_COOLDOWN.get())).setDefaultValue(HuntingClothConfigScreen.copyList((List)HuntingConfig.KNIFE_CATEGORY_COOLDOWN.get())).setSaveConsumer(list -> HuntingConfig.KNIFE_CATEGORY_COOLDOWN.set(HuntingClothConfigScreen.copyList(list))).setTooltip(new Component[]{Component.m_237113_((String)"Format: category=ticks between cuts")}).build());
        knives.addEntry((AbstractConfigListEntry)entry.startStrList((Component)Component.m_237113_((String)"Category Extra Slices"), HuntingClothConfigScreen.copyList((List)HuntingConfig.KNIFE_CATEGORY_EXTRA_SLICES.get())).setDefaultValue(HuntingClothConfigScreen.copyList((List)HuntingConfig.KNIFE_CATEGORY_EXTRA_SLICES.get())).setSaveConsumer(list -> HuntingConfig.KNIFE_CATEGORY_EXTRA_SLICES.set(HuntingClothConfigScreen.copyList(list))).setTooltip(new Component[]{Component.m_237113_((String)"Format: category=extraSlices (decimals allowed, adds to attribute)")}).build());
        knives.addEntry((AbstractConfigListEntry)((DoubleFieldBuilder)entry.startDoubleField((Component)Component.m_237113_((String)"Exhaustion Per Use"), ((Double)HuntingConfig.EXHAUSTION_PER_USE.get()).doubleValue()).setDefaultValue((Object)((Double)HuntingConfig.EXHAUSTION_PER_USE.get()))).setMin(0.0).setMax(4.0).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.DoubleValue)HuntingConfig.EXHAUSTION_PER_USE).set(arg_0)).build());
        knives.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)entry.startBooleanToggle((Component)Component.m_237113_((String)"Knife Tooltips"), ((Boolean)HuntingConfig.KNIFE_TOOLTIPS_ENABLED.get()).booleanValue()).setDefaultValue((Object)((Boolean)HuntingConfig.KNIFE_TOOLTIPS_ENABLED.get()))).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)HuntingConfig.KNIFE_TOOLTIPS_ENABLED).set(arg_0)).setTooltip(new Component[]{Component.m_237113_((String)"Show knife tooltips only while holding Shift")}).build());
        ConfigCategory drops = builder.getOrCreateCategory((Component)Component.m_237113_((String)"Drops"));
        drops.addEntry((AbstractConfigListEntry)entry.startStrList((Component)Component.m_237113_((String)"Carcass Whitelist"), HuntingClothConfigScreen.copyList((List)HuntingConfig.CARCASS_WHITELIST.get())).setDefaultValue(HuntingClothConfigScreen.copyList((List)HuntingConfig.CARCASS_WHITELIST.get())).setSaveConsumer(list -> HuntingConfig.CARCASS_WHITELIST.set(HuntingClothConfigScreen.copyList(list))).setTooltip(new Component[]{Component.m_237113_((String)"Items captured into carcass. One carcass per mob.")}).build());
        return builder.build();
    }

    private static List<String> copyList(List<? extends String> in) {
        return new ArrayList<String>(in);
    }
}

