/*
 * Decompiled with CFR 0.152.
 */
package com.joseetoon.carcass.compat.farmersdelight;

import com.joseetoon.carcass.block.entity.CarcassBlockEntity;
import com.joseetoon.carcass.config.HuntingConfig;
import com.joseetoon.carcass.registry.CarcassBlocks;
import com.joseetoon.carcass.registry.CarcassParticles;
import com.joseetoon.carcass.util.KnifeStats;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="carcass")
public class FarmersDelightCompat {
    private static final ResourceLocation CUTTING_BOARD_ID = new ResourceLocation("farmersdelight", "cutting_board");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!ModList.get().isLoaded("farmersdelight")) {
            return;
        }
        if (event.getItemStack().m_41619_() || !KnifeStats.isHuntersKnife(event.getItemStack())) {
            return;
        }
        if (!FarmersDelightCompat.isCuttingBoard(event.getLevel().m_8055_(event.getPos()))) {
            return;
        }
        BlockEntity be = event.getLevel().m_7702_(event.getPos());
        if (be == null) {
            return;
        }
        ItemStack carcass = FarmersDelightCompat.getCarcassFromBoard(be);
        if (carcass.m_41619_()) {
            return;
        }
        if (event.getLevel().f_46443_) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        FarmersDelightCompat.processCuttingBoard(event.getLevel(), be, event.getItemStack(), event.getEntity(), carcass);
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    private static void processCuttingBoard(Level level, BlockEntity be, ItemStack knife, Player player, ItemStack carcass) {
        LazyOptional handlerOpt = be.getCapability(ForgeCapabilities.ITEM_HANDLER);
        handlerOpt.ifPresent(handler -> {
            if (handler.getSlots() < 1) {
                return;
            }
            ItemStack stored = handler.getStackInSlot(0);
            if (!ItemStack.m_41728_((ItemStack)stored, (ItemStack)carcass)) {
                return;
            }
            if (((Boolean)HuntingConfig.ENABLE_PLAYER_ITEM_COOLDOWN.get()).booleanValue() && player.m_36335_().m_41519_(knife.m_41720_())) {
                FarmersDelightCompat.spawnCooldownFeedback(level, be.m_58899_());
                return;
            }
            long nextReady = CarcassBlockEntity.readLastUseFromStack(stored);
            int cooldown = KnifeStats.getCooldownTicks(knife, player, true);
            long now = level.m_46467_();
            if (cooldown > 0 && now < nextReady) {
                FarmersDelightCompat.applyRemainingItemCooldown(player, knife, nextReady - now);
                FarmersDelightCompat.spawnCooldownFeedback(level, be.m_58899_());
                return;
            }
            NonNullList<ItemStack> items = CarcassBlockEntity.readItemsFromStack(stored);
            if (FarmersDelightCompat.isEmpty(items)) {
                return;
            }
            List<ItemStack> drops = FarmersDelightCompat.takeSlices(level, knife, player, items);
            if (drops.isEmpty()) {
                return;
            }
            if (FarmersDelightCompat.isEmpty(items)) {
                handler.extractItem(0, stored.m_41613_(), false);
            } else {
                CarcassBlockEntity.writeItemsToStack(stored, items);
                CarcassBlockEntity.writeLastUseToStack(stored, now + (long)Math.max(0, cooldown));
                handler.extractItem(0, stored.m_41613_(), false);
                handler.insertItem(0, stored, false);
            }
            Vec3 effectPos = be.m_58899_().m_252807_();
            for (ItemStack drop : drops) {
                FarmersDelightCompat.giveOrDrop(player, drop);
                FarmersDelightCompat.spawnSliceEffects(level, effectPos);
            }
            int playerCooldownTicks = KnifeStats.getPlayerCooldownTicks(knife, true);
            if (playerCooldownTicks > 0) {
                player.m_36335_().m_41524_(knife.m_41720_(), playerCooldownTicks);
            }
        });
    }

    private static boolean isCuttingBoard(BlockState state) {
        ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        return CUTTING_BOARD_ID.equals((Object)key);
    }

    private static List<ItemStack> takeSlices(Level level, ItemStack knife, Player player, NonNullList<ItemStack> items) {
        ItemStack drop;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int extraSlices = KnifeStats.rollExtraSlices(knife, player, level.m_213780_());
        int slices = 1 + extraSlices;
        for (int i = 0; i < slices && !(drop = FarmersDelightCompat.extractNextItem(items)).m_41619_(); ++i) {
            drops.add(drop);
            KnifeStats.damageKnife(knife, player);
            KnifeStats.applyExhaustion(player);
            if (knife.m_41619_()) break;
        }
        return drops;
    }

    private static ItemStack extractNextItem(NonNullList<ItemStack> items) {
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.m_41619_()) continue;
            ItemStack result = stack.m_41620_(1);
            if (stack.m_41619_()) {
                items.set(i, (Object)ItemStack.f_41583_);
            }
            return result;
        }
        return ItemStack.f_41583_;
    }

    private static boolean isEmpty(NonNullList<ItemStack> list) {
        for (ItemStack stack : list) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    private static void giveOrDrop(Player player, ItemStack drop) {
        if (!player.m_36356_(drop)) {
            player.m_36176_(drop, false);
        }
    }

    private static ItemStack getCarcassFromBoard(BlockEntity be) {
        ItemStack[] result = new ItemStack[]{ItemStack.f_41583_};
        be.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            BlockItem blockItem;
            if (handler.getSlots() < 1) {
                return;
            }
            ItemStack stored = handler.getStackInSlot(0);
            Item patt7069$temp = stored.m_41720_();
            if (patt7069$temp instanceof BlockItem && (blockItem = (BlockItem)patt7069$temp).m_40614_() == CarcassBlocks.CARCASS.get()) {
                result[0] = stored;
            }
        });
        return result[0];
    }

    private static void spawnCooldownFeedback(Level level, BlockPos pos) {
        if (level.f_46443_) {
            return;
        }
        int messageIndex = (Boolean)HuntingConfig.ENABLE_RANDOM_COOLDOWN_MESSAGES.get() != false ? level.m_213780_().m_188503_(4) : -1;
        int messageColor = (Integer)HuntingConfig.COOLDOWN_MESSAGE_COLOR.get();
        double px = (double)pos.m_123341_() + 0.5;
        double py = (double)pos.m_123342_() + 1.1;
        double pz = (double)pos.m_123343_() + 0.5;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)CarcassParticles.COOLDOWN_MESSAGE.get()), px, py, pz, 0, (double)messageIndex, (double)messageColor, 0.0, 1.0);
        }
        if (((Boolean)HuntingConfig.COOLDOWN_SOUND_ENABLED.get()).booleanValue()) {
            level.m_5594_(null, pos, SoundEvents.f_12315_, SoundSource.BLOCKS, ((Double)HuntingConfig.COOLDOWN_SOUND_VOLUME.get()).floatValue(), 0.7f + level.m_213780_().m_188501_() * 0.4f);
        }
        if (((Boolean)HuntingConfig.COOLDOWN_PARTICLES_ENABLED.get()).booleanValue()) {
            FarmersDelightCompat.spawnFailureParticles(level, pos);
        }
    }

    private static void spawnFailureParticles(Level level, BlockPos pos) {
        double cx = (double)pos.m_123341_() + 0.5;
        double cy = (double)pos.m_123342_() + 1.1;
        double cz = (double)pos.m_123343_() + 0.5;
        Vector3f smokeFrom = new Vector3f(0.5f, 0.5f, 0.5f);
        Vector3f smokeTo = new Vector3f(0.3f, 0.3f, 0.3f);
        int count = (Integer)HuntingConfig.COOLDOWN_PARTICLE_COUNT.get();
        for (int i = 0; i < count; ++i) {
            double vx = (level.m_213780_().m_188500_() - 0.5) * 0.1;
            double vy = level.m_213780_().m_188500_() * 0.05;
            double vz = (level.m_213780_().m_188500_() - 0.5) * 0.1;
            level.m_7106_((ParticleOptions)new DustColorTransitionOptions(smokeFrom, smokeTo, 1.0f), cx, cy, cz, vx, vy, vz);
            if (i % 2 != 0) continue;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, cx, cy, cz, vx * 0.5, vy * 0.2, vz * 0.5);
        }
    }

    private static void applyRemainingItemCooldown(Player player, ItemStack held, long remainingTicks) {
        if (!((Boolean)HuntingConfig.ENABLE_PLAYER_ITEM_COOLDOWN.get()).booleanValue()) {
            return;
        }
        int ticks = (int)Math.min(Integer.MAX_VALUE, Math.max(0L, remainingTicks));
        if (ticks > 0) {
            player.m_36335_().m_41524_(held.m_41720_(), ticks);
        }
    }

    private static void spawnSliceEffects(Level level, Vec3 pos) {
        if (((Boolean)HuntingConfig.SLICE_SOUND_ENABLED.get()).booleanValue()) {
            float basePitch = 0.9f;
            float jitter = ((Double)HuntingConfig.SLICE_SOUND_PITCH_JITTER.get()).floatValue();
            float pitch = basePitch + level.m_213780_().m_188501_() * jitter;
            level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12393_, SoundSource.BLOCKS, ((Double)HuntingConfig.SLICE_SOUND_VOLUME.get()).floatValue(), pitch);
        }
        if (((Boolean)HuntingConfig.SLICE_PARTICLES_ENABLED.get()).booleanValue()) {
            int count = (Integer)HuntingConfig.SLICE_PARTICLE_COUNT.get();
            Vector3f bloodFrom = new Vector3f(0.9f, 0.1f, 0.1f);
            Vector3f bloodTo = new Vector3f(0.4f, 0.0f, 0.0f);
            int bloodCount = Math.min(80, Math.max(12, count * 4));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_, pos.f_82480_, pos.f_82481_, count, 0.1, 0.1, 0.1, 0.1);
                serverLevel.m_8767_((ParticleOptions)new DustColorTransitionOptions(bloodFrom, bloodTo, 1.6f), pos.f_82479_, pos.f_82480_, pos.f_82481_, bloodCount, 0.25, 0.2, 0.25, 0.2);
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50451_.m_49966_()), pos.f_82479_, pos.f_82480_, pos.f_82481_, bloodCount, 0.25, 0.2, 0.25, 0.1);
            } else {
                double vz;
                double vy;
                double vx;
                int i;
                for (i = 0; i < count; ++i) {
                    vx = (level.m_213780_().m_188500_() - 0.5) * 0.1;
                    vy = level.m_213780_().m_188500_() * 0.1;
                    vz = (level.m_213780_().m_188500_() - 0.5) * 0.1;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_, pos.f_82480_, pos.f_82481_, vx, vy, vz);
                }
                for (i = 0; i < bloodCount; ++i) {
                    vx = (level.m_213780_().m_188500_() - 0.5) * 0.25;
                    vy = level.m_213780_().m_188500_() * 0.2;
                    vz = (level.m_213780_().m_188500_() - 0.5) * 0.25;
                    level.m_7106_((ParticleOptions)new DustColorTransitionOptions(bloodFrom, bloodTo, 1.6f), pos.f_82479_, pos.f_82480_, pos.f_82481_, vx, vy, vz);
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50451_.m_49966_()), pos.f_82479_, pos.f_82480_, pos.f_82481_, vx * 0.4, vy * 0.4, vz * 0.4);
                }
            }
        }
    }
}

