/*
 * Decompiled with CFR 0.152.
 */
package com.joseetoon.carcass.compat.jade;

import com.joseetoon.carcass.block.BlockButchersBlock;
import com.joseetoon.carcass.block.BlockCarcass;
import com.joseetoon.carcass.block.entity.ButchersBlockEntity;
import com.joseetoon.carcass.block.entity.CarcassBlockEntity;
import com.joseetoon.carcass.registry.CarcassBlocks;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class CarcassJadePlugin
implements IWailaPlugin,
IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final ResourceLocation UID = new ResourceLocation("carcass", "carcass_info");
    public static final ResourceLocation SHOW_LAST_LOOT = new ResourceLocation("carcass", "show_carcass_last_loot");
    public static final ResourceLocation SHOW_REMAINING = new ResourceLocation("carcass", "show_carcass_remaining");
    public static final ResourceLocation SHOW_COOLDOWN = new ResourceLocation("carcass", "show_carcass_cooldown");
    private static final String TAG_HAS_CARCASS = "HasCarcass";
    private static final String TAG_LAST_DROP = "LastDrop";
    private static final String TAG_REMAINING = "Remaining";
    private static final String TAG_COOLDOWN = "Cooldown";
    private static final String CUTTING_BOARD_BE = "vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity";

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)this, Block.class);
        registration.addConfig(SHOW_LAST_LOOT, true);
        registration.addConfig(SHOW_REMAINING, true);
        registration.addConfig(SHOW_COOLDOWN, true);
    }

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)this, BlockEntity.class);
    }

    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        Level level = accessor.getLevel();
        CarcassData data = CarcassJadePlugin.resolveCarcassData(level, accessor.getPosition(), accessor.getBlockEntity());
        if (data == null) {
            if (CarcassJadePlugin.isPrimaryCarcassBlock(accessor)) {
                tag.m_128379_(TAG_HAS_CARCASS, false);
            }
            return;
        }
        tag.m_128379_(TAG_HAS_CARCASS, true);
        if (!data.lastDrop.m_41619_()) {
            tag.m_128365_(TAG_LAST_DROP, (Tag)data.lastDrop.m_41739_(new CompoundTag()));
        }
        tag.m_128405_(TAG_REMAINING, data.remainingCount);
        tag.m_128356_(TAG_COOLDOWN, data.cooldownTicks);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        ItemStack lastDrop;
        CompoundTag data = accessor.getServerData();
        if (data == null || !data.m_128441_(TAG_HAS_CARCASS)) {
            return;
        }
        if (!data.m_128471_(TAG_HAS_CARCASS)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.carcass.carcass.missing"));
            return;
        }
        if (config.get(SHOW_LAST_LOOT) && data.m_128441_(TAG_LAST_DROP) && !(lastDrop = ItemStack.m_41712_((CompoundTag)data.m_128469_(TAG_LAST_DROP))).m_41619_()) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.carcass.carcass.last", (Object[])new Object[]{lastDrop.m_41786_()}));
        }
        if (config.get(SHOW_REMAINING)) {
            int remaining = data.m_128451_(TAG_REMAINING);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.carcass.carcass.remaining", (Object[])new Object[]{remaining}));
        }
        if (config.get(SHOW_COOLDOWN)) {
            long cooldownTicks = data.m_128454_(TAG_COOLDOWN);
            if (cooldownTicks > 0L) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.carcass.carcass.cooldown", (Object[])new Object[]{CarcassJadePlugin.formatSeconds(cooldownTicks)}));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.carcass.carcass.ready"));
            }
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }

    private static CarcassData resolveCarcassData(Level level, BlockPos pos, BlockEntity blockEntity) {
        CarcassData cuttingBoardData;
        CarcassBlockEntity carcass = CarcassJadePlugin.resolveCarcass(level, pos, blockEntity);
        if (carcass != null) {
            long now = level.m_46467_();
            long remainingTicks = Math.max(0L, carcass.getCooldownUntilTick() - now);
            return new CarcassData(carcass.getLastDropPreview(), carcass.getRemainingDropCount(), remainingTicks);
        }
        if (blockEntity instanceof ButchersBlockEntity) {
            ButchersBlockEntity butcher = (ButchersBlockEntity)blockEntity;
            ItemStack lastDrop = butcher.getLastDropPreview();
            int remainingCount = butcher.getRemainingDropCount();
            if (!lastDrop.m_41619_() || remainingCount > 0) {
                return new CarcassData(lastDrop, remainingCount, 0L);
            }
        }
        if ((cuttingBoardData = CarcassJadePlugin.resolveCuttingBoardData(level, blockEntity)) != null) {
            return cuttingBoardData;
        }
        return null;
    }

    private static CarcassBlockEntity resolveCarcass(Level level, BlockPos pos, BlockEntity blockEntity) {
        if (blockEntity instanceof CarcassBlockEntity) {
            CarcassBlockEntity carcass = (CarcassBlockEntity)blockEntity;
            return carcass;
        }
        BlockEntity above = level.m_7702_(pos.m_7494_());
        if (above instanceof CarcassBlockEntity) {
            CarcassBlockEntity carcassAbove = (CarcassBlockEntity)above;
            return carcassAbove;
        }
        return null;
    }

    private static CarcassData resolveCuttingBoardData(Level level, BlockEntity blockEntity) {
        if (blockEntity == null || !CarcassJadePlugin.isCuttingBoard(blockEntity)) {
            return null;
        }
        ItemStack carcassStack = CarcassJadePlugin.getCarcassFromBoard(blockEntity);
        if (carcassStack.m_41619_()) {
            return null;
        }
        NonNullList<ItemStack> items = CarcassBlockEntity.readItemsFromStack(carcassStack);
        ItemStack lastDrop = CarcassJadePlugin.getLastDropPreview(items);
        int remainingCount = CarcassJadePlugin.getRemainingCount(items);
        if (lastDrop.m_41619_() && remainingCount <= 0) {
            return null;
        }
        long cooldownUntil = CarcassBlockEntity.readLastUseFromStack(carcassStack);
        long remainingTicks = Math.max(0L, cooldownUntil - level.m_46467_());
        return new CarcassData(lastDrop, remainingCount, remainingTicks);
    }

    private static ItemStack getCarcassFromBoard(BlockEntity blockEntity) {
        ItemStack[] result = new ItemStack[]{ItemStack.f_41583_};
        LazyOptional handlerOpt = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
        handlerOpt.ifPresent(handler -> {
            BlockItem blockItem;
            if (handler.getSlots() < 1) {
                return;
            }
            ItemStack stored = handler.getStackInSlot(0);
            Item patt7178$temp = stored.m_41720_();
            if (patt7178$temp instanceof BlockItem && (blockItem = (BlockItem)patt7178$temp).m_40614_() == CarcassBlocks.CARCASS.get()) {
                result[0] = stored;
            }
        });
        return result[0];
    }

    private static ItemStack getLastDropPreview(NonNullList<ItemStack> items) {
        for (int i = items.size() - 1; i >= 0; --i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.m_41619_()) continue;
            return stack.m_255036_(1);
        }
        return ItemStack.f_41583_;
    }

    private static int getRemainingCount(NonNullList<ItemStack> items) {
        int count = 0;
        for (ItemStack stack : items) {
            if (stack.m_41619_()) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private static boolean isCuttingBoard(BlockEntity blockEntity) {
        return CUTTING_BOARD_BE.equals(blockEntity.getClass().getName());
    }

    private static boolean isPrimaryCarcassBlock(BlockAccessor accessor) {
        return accessor.getBlock() instanceof BlockCarcass || accessor.getBlock() instanceof BlockButchersBlock;
    }

    private static String formatSeconds(long ticks) {
        return String.format(Locale.US, "%.1f", (double)ticks / 20.0);
    }

    private record CarcassData(ItemStack lastDrop, int remainingCount, long cooldownTicks) {
    }
}

