/*
 * Decompiled with CFR 0.152.
 */
package com.joseetoon.carcass.compat.top;

import com.joseetoon.carcass.block.entity.ButchersBlockEntity;
import com.joseetoon.carcass.block.entity.CarcassBlockEntity;
import com.joseetoon.carcass.registry.CarcassBlocks;
import java.util.Locale;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class CarcassProbeInfoProvider
implements IProbeInfoProvider {
    public static final ResourceLocation ID = new ResourceLocation("carcass", "carcass_info");
    private static final String CUTTING_BOARD_BE = "vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity";

    public static Void register(Object probe) {
        ITheOneProbe top = (ITheOneProbe)probe;
        top.registerProvider((IProbeInfoProvider)new CarcassProbeInfoProvider());
        return null;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData data) {
        BlockEntity blockEntity;
        BlockPos pos = data.getPos();
        CarcassData info = CarcassProbeInfoProvider.resolveCarcassData(level, pos, blockEntity = level.m_7702_(pos));
        if (info == null) {
            return;
        }
        if (!info.lastDrop.m_41619_()) {
            probeInfo.horizontal().item(info.lastDrop).text((Component)Component.m_237110_((String)"tooltip.carcass.carcass.last", (Object[])new Object[]{info.lastDrop.m_41786_()}));
        }
        probeInfo.text((Component)Component.m_237110_((String)"tooltip.carcass.carcass.remaining", (Object[])new Object[]{info.remainingCount}));
        if (info.cooldownTicks > 0L) {
            probeInfo.text((Component)Component.m_237110_((String)"tooltip.carcass.carcass.cooldown", (Object[])new Object[]{CarcassProbeInfoProvider.formatSeconds(info.cooldownTicks)}));
        } else {
            probeInfo.text((Component)Component.m_237115_((String)"tooltip.carcass.carcass.ready"));
        }
    }

    private static CarcassData resolveCarcassData(Level level, BlockPos pos, BlockEntity blockEntity) {
        CarcassData cuttingBoardData;
        CarcassBlockEntity carcass = CarcassProbeInfoProvider.resolveCarcass(level, pos, blockEntity);
        if (carcass != null) {
            long now = level.m_46467_();
            long remainingTicks = Math.max(0L, carcass.getCooldownUntilTick() - now);
            return new CarcassData(carcass.getLastDropPreview(), carcass.getRemainingDropCount(), remainingTicks);
        }
        if (blockEntity instanceof ButchersBlockEntity) {
            ButchersBlockEntity butcher = (ButchersBlockEntity)blockEntity;
            ItemStack lastDrop = butcher.getLastDropPreview();
            int remainingCount = butcher.getRemainingDropCount();
            if (!lastDrop.m_41619_() || remainingCount > 0) {
                return new CarcassData(lastDrop, remainingCount, 0L);
            }
        }
        if ((cuttingBoardData = CarcassProbeInfoProvider.resolveCuttingBoardData(level, blockEntity)) != null) {
            return cuttingBoardData;
        }
        return null;
    }

    private static CarcassBlockEntity resolveCarcass(Level level, BlockPos pos, BlockEntity blockEntity) {
        if (blockEntity instanceof CarcassBlockEntity) {
            CarcassBlockEntity carcass = (CarcassBlockEntity)blockEntity;
            return carcass;
        }
        BlockEntity above = level.m_7702_(pos.m_7494_());
        if (above instanceof CarcassBlockEntity) {
            CarcassBlockEntity carcassAbove = (CarcassBlockEntity)above;
            return carcassAbove;
        }
        return null;
    }

    private static CarcassData resolveCuttingBoardData(Level level, BlockEntity blockEntity) {
        if (blockEntity == null || !CarcassProbeInfoProvider.isCuttingBoard(blockEntity)) {
            return null;
        }
        ItemStack carcassStack = CarcassProbeInfoProvider.getCarcassFromBoard(blockEntity);
        if (carcassStack.m_41619_()) {
            return null;
        }
        NonNullList<ItemStack> items = CarcassBlockEntity.readItemsFromStack(carcassStack);
        ItemStack lastDrop = CarcassProbeInfoProvider.getLastDropPreview(items);
        int remainingCount = CarcassProbeInfoProvider.getRemainingCount(items);
        if (lastDrop.m_41619_() && remainingCount <= 0) {
            return null;
        }
        long cooldownUntil = CarcassBlockEntity.readLastUseFromStack(carcassStack);
        long remainingTicks = Math.max(0L, cooldownUntil - level.m_46467_());
        return new CarcassData(lastDrop, remainingCount, remainingTicks);
    }

    private static ItemStack getCarcassFromBoard(BlockEntity blockEntity) {
        ItemStack[] result = new ItemStack[]{ItemStack.f_41583_};
        LazyOptional handlerOpt = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
        handlerOpt.ifPresent(handler -> {
            BlockItem blockItem;
            if (handler.getSlots() < 1) {
                return;
            }
            ItemStack stored = handler.getStackInSlot(0);
            Item patt5100$temp = stored.m_41720_();
            if (patt5100$temp instanceof BlockItem && (blockItem = (BlockItem)patt5100$temp).m_40614_() == CarcassBlocks.CARCASS.get()) {
                result[0] = stored;
            }
        });
        return result[0];
    }

    private static ItemStack getLastDropPreview(NonNullList<ItemStack> items) {
        for (int i = items.size() - 1; i >= 0; --i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.m_41619_()) continue;
            return stack.m_255036_(1);
        }
        return ItemStack.f_41583_;
    }

    private static int getRemainingCount(NonNullList<ItemStack> items) {
        int count = 0;
        for (ItemStack stack : items) {
            if (stack.m_41619_()) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private static boolean isCuttingBoard(BlockEntity blockEntity) {
        return CUTTING_BOARD_BE.equals(blockEntity.getClass().getName());
    }

    private static String formatSeconds(long ticks) {
        return String.format(Locale.US, "%.1f", (double)ticks / 20.0);
    }

    private record CarcassData(ItemStack lastDrop, int remainingCount, long cooldownTicks) {
    }
}

