/*
 * Decompiled with CFR 0.152.
 */
package com.joseetoon.carcass.config;

import com.joseetoon.carcass.util.KnifeStats;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="carcass", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HuntingConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CARCASS_WHITELIST = BUILDER.comment("Items that, when dropped by a mob, will be captured into a single carcass instead of dropping normally.").defineList("carcassWhitelist", Arrays.asList("minecraft:leather", "minecraft:beef", "minecraft:porkchop", "minecraft:chicken", "minecraft:mutton"), o -> o instanceof String);
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> KNIFE_CATEGORY_ITEMS = BUILDER.comment("Assign items to categories: category=modid:item,modid:item2").defineList("knifeCategoryItems", Arrays.asList("flint=carcass:flint_butchers_knife", "stone=carcass:stone_butchers_knife", "bone=carcass:bone_butchers_knife", "gold=carcass:gold_butchers_knife", "iron=carcass:iron_butchers_knife", "diamond=carcass:diamond_butchers_knife", "netherite=carcass:netherite_butchers_knife"), o -> o instanceof String);
    public static final ForgeConfigSpec.DoubleValue EXHAUSTION_PER_USE;
    public static final ForgeConfigSpec.BooleanValue KNIFE_TOOLTIPS_ENABLED;
    public static final ForgeConfigSpec.BooleanValue SLICE_PARTICLES_ENABLED;
    public static final ForgeConfigSpec.IntValue SLICE_PARTICLE_COUNT;
    public static final ForgeConfigSpec.BooleanValue SLICE_SOUND_ENABLED;
    public static final ForgeConfigSpec.DoubleValue SLICE_SOUND_VOLUME;
    public static final ForgeConfigSpec.DoubleValue SLICE_SOUND_PITCH_JITTER;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> KNIFE_CATEGORY_COOLDOWN;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> KNIFE_CATEGORY_EXTRA_SLICES;
    public static final ForgeConfigSpec.BooleanValue ENABLE_PLAYER_ITEM_COOLDOWN;
    public static final ForgeConfigSpec.BooleanValue ENABLE_RANDOM_COOLDOWN_MESSAGES;
    public static final ForgeConfigSpec.DoubleValue COOLDOWN_MESSAGE_LIFETIME;
    public static final ForgeConfigSpec.DoubleValue COOLDOWN_MESSAGE_SLIDE_SPEED;
    public static final ForgeConfigSpec.IntValue COOLDOWN_MESSAGE_COLOR;
    public static final ForgeConfigSpec.BooleanValue COOLDOWN_PARTICLES_ENABLED;
    public static final ForgeConfigSpec.IntValue COOLDOWN_PARTICLE_COUNT;
    public static final ForgeConfigSpec.BooleanValue COOLDOWN_SOUND_ENABLED;
    public static final ForgeConfigSpec.DoubleValue COOLDOWN_SOUND_VOLUME;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static ModConfig COMMON_CONFIG;

    @SubscribeEvent
    public static void onConfigLoaded(ModConfigEvent event) {
        if (event.getConfig().getSpec() == COMMON_SPEC) {
            COMMON_CONFIG = event.getConfig();
            KnifeStats.invalidate();
        }
    }

    static {
        KNIFE_CATEGORY_COOLDOWN = BUILDER.comment("Knife category cooldown in ticks between cuts: category=ticks").defineList("knifeCategoryCooldowns", Arrays.asList("flint=100", "stone=90", "bone=80", "gold=70", "iron=60", "diamond=50", "netherite=40"), o -> o instanceof String);
        KNIFE_CATEGORY_EXTRA_SLICES = BUILDER.comment("Additional slices per category: category=extraSlices (decimals allowed; 2.3 = +2 and 30% chance for +1)").defineList("knifeCategoryExtraSlices", Arrays.asList("flint=0", "stone=0", "bone=0", "gold=1", "iron=1", "diamond=2", "netherite=3"), o -> o instanceof String);
        ENABLE_PLAYER_ITEM_COOLDOWN = BUILDER.comment("Enable player item cooldown (prevents spam-clicking)").define("enablePlayerItemCooldown", true);
        EXHAUSTION_PER_USE = BUILDER.comment("Exhaustion applied per knife use.").defineInRange("exhaustionPerUse", 0.08, 0.0, 4.0);
        KNIFE_TOOLTIPS_ENABLED = BUILDER.comment("Enable knife tooltips (shown only while holding Shift)").define("knifeTooltipsEnabled", true);
        SLICE_PARTICLES_ENABLED = BUILDER.comment("Enable particles when slicing a carcass.").define("sliceParticlesEnabled", true);
        SLICE_PARTICLE_COUNT = BUILDER.comment("Number of crit particles to spawn when slicing.").defineInRange("sliceParticleCount", 6, 0, 50);
        SLICE_SOUND_ENABLED = BUILDER.comment("Enable slime step sound when slicing a carcass.").define("sliceSoundEnabled", true);
        SLICE_SOUND_VOLUME = BUILDER.comment("Volume for slice sound.").defineInRange("sliceSoundVolume", 0.6, 0.0, 4.0);
        SLICE_SOUND_PITCH_JITTER = BUILDER.comment("Pitch jitter range added to 1.0f for slice sound.").defineInRange("sliceSoundPitchJitter", 0.2, 0.0, 1.0);
        ENABLE_RANDOM_COOLDOWN_MESSAGES = BUILDER.comment("Enable random cooldown failure messages (MISS, WAIT, etc.)").define("enableRandomCooldownMessages", true);
        COOLDOWN_MESSAGE_LIFETIME = BUILDER.comment("Lifetime of cooldown message particles in seconds").defineInRange("cooldownMessageLifetime", 2.0, 0.5, 10.0);
        COOLDOWN_MESSAGE_SLIDE_SPEED = BUILDER.comment("Speed of upward slide animation").defineInRange("cooldownMessageSlideSpeed", 0.02, 0.0, 0.1);
        COOLDOWN_MESSAGE_COLOR = BUILDER.comment("Color of cooldown messages in hex (0xRRGGBB)").defineInRange("cooldownMessageColor", 0xFF4444, 0, 0xFFFFFF);
        COOLDOWN_PARTICLES_ENABLED = BUILDER.comment("Enable particles for cooldown failure").define("cooldownParticlesEnabled", true);
        COOLDOWN_PARTICLE_COUNT = BUILDER.comment("Number of particles for cooldown failure").defineInRange("cooldownParticleCount", 6, 0, 30);
        COOLDOWN_SOUND_ENABLED = BUILDER.comment("Enable sound for cooldown failure").define("cooldownSoundEnabled", true);
        COOLDOWN_SOUND_VOLUME = BUILDER.comment("Volume for cooldown failure sound").defineInRange("cooldownSoundVolume", 0.6, 0.0, 2.0);
        COMMON_SPEC = BUILDER.build();
    }
}

