/*
 * Decompiled with CFR 0.152.
 */
package com.joseetoon.carcass.event;

import com.joseetoon.carcass.block.entity.CarcassBlockEntity;
import com.joseetoon.carcass.config.HuntingConfig;
import com.joseetoon.carcass.registry.CarcassBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="carcass")
public class CarcassDropHandler {
    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        Level level = event.getEntity().m_9236_();
        if (level.f_46443_) {
            return;
        }
        HashSet<ResourceLocation> whitelist = new HashSet<ResourceLocation>();
        for (String entry : (List)HuntingConfig.CARCASS_WHITELIST.get()) {
            String trimmed = entry.trim();
            if (trimmed.isEmpty()) continue;
            try {
                whitelist.add(new ResourceLocation(trimmed));
            }
            catch (Exception exception) {}
        }
        if (whitelist.isEmpty()) {
            return;
        }
        ArrayList<ItemEntity> captured = new ArrayList<ItemEntity>();
        Iterator iterator = event.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemEntity entity = (ItemEntity)iterator.next();
            ItemStack stack = entity.m_32055_();
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
            if (id == null || !whitelist.contains(id)) continue;
            captured.add(entity);
            iterator.remove();
        }
        if (captured.isEmpty()) {
            return;
        }
        ItemStack carcass = new ItemStack((ItemLike)CarcassBlocks.CARCASS.get());
        NonNullList items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        int slot = 0;
        for (ItemEntity capturedEntity : captured) {
            ItemStack stack = capturedEntity.m_32055_();
            if (slot < items.size()) {
                items.set(slot++, (Object)stack.m_41777_());
                continue;
            }
            event.getDrops().add(capturedEntity);
        }
        CarcassBlockEntity.writeItemsToStack(carcass, (NonNullList<ItemStack>)items);
        ItemEntity carcassEntity = new ItemEntity(level, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), carcass);
        event.getDrops().add(carcassEntity);
    }
}

