/*
 * Decompiled with CFR 0.152.
 */
package com.joseetoon.carcass.event;

import com.joseetoon.carcass.registry.CarcassAttributes;
import com.joseetoon.carcass.util.KnifeStats;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="carcass")
public final class KnifeAttributeEventHandler {
    private KnifeAttributeEventHandler() {
    }

    @SubscribeEvent
    public static void onItemAttributes(ItemAttributeModifierEvent event) {
        if (event.getSlotType() != EquipmentSlot.MAINHAND) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_() || !KnifeStats.isHuntersKnife(stack)) {
            return;
        }
        Attribute attrSlices = (Attribute)CarcassAttributes.EXTRA_SLICES.get();
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (key == null) {
            return;
        }
        double extraSlices = KnifeStats.getConfiguredExtraSlices(stack);
        if (extraSlices != 0.0) {
            UUID slicesId = UUID.nameUUIDFromBytes(("carcass:" + String.valueOf(key) + ":extra_slices").getBytes(StandardCharsets.UTF_8));
            AttributeModifier slicesMod = new AttributeModifier(slicesId, "knife_extra_slices", extraSlices, AttributeModifier.Operation.ADDITION);
            event.addModifier(attrSlices, slicesMod);
        }
        int baseCooldown = KnifeStats.getConfiguredCooldownTicks(stack);
        UUID cooldownId = UUID.nameUUIDFromBytes(("carcass:" + String.valueOf(key) + ":knife_cooldown").getBytes(StandardCharsets.UTF_8));
        AttributeModifier cooldownMod = new AttributeModifier(cooldownId, "knife_cooldown", (double)baseCooldown, AttributeModifier.Operation.ADDITION);
        event.addModifier((Attribute)CarcassAttributes.KNIFE_COOLDOWN.get(), cooldownMod);
    }
}

