/*
 * Decompiled with CFR 0.152.
 */
package com.joseetoon.carcass.event;

import com.joseetoon.carcass.config.HuntingConfig;
import com.joseetoon.carcass.util.KnifeStats;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="carcass", value={Dist.CLIENT})
public class KnifeTooltipEventHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Optional<String> catOpt = KnifeStats.getCategory(stack);
        if (catOpt.isEmpty()) {
            return;
        }
        String extraKey = "attribute.carcass.extra_slices";
        String cooldownKey = "attribute.carcass.knife_cooldown";
        String extraName = Component.m_237115_((String)extraKey).getString();
        String cooldownName = Component.m_237115_((String)cooldownKey).getString();
        event.getToolTip().removeIf(component -> {
            String text = component.getString();
            return text.contains(extraName) || text.contains(extraKey) || text.contains(cooldownName) || text.contains(cooldownKey);
        });
        if (!((Boolean)HuntingConfig.KNIFE_TOOLTIPS_ENABLED.get()).booleanValue()) {
            return;
        }
        if (!Screen.m_96638_()) {
            return;
        }
        String category = catOpt.get();
        int efficiency = KnifeStats.getEfficiency(stack);
        event.getToolTip().add(Component.m_237113_((String)(String.valueOf(ChatFormatting.GRAY) + "Knife category: " + String.valueOf(ChatFormatting.YELLOW) + category)));
        event.getToolTip().add(Component.m_237113_((String)(String.valueOf(ChatFormatting.GRAY) + "Efficiency: " + String.valueOf(ChatFormatting.GREEN) + efficiency)));
        double extraSlices = Math.max(0.0, KnifeStats.getExtraSlicesValue(stack, event.getEntity()));
        event.getToolTip().add(Component.m_237110_((String)"tooltip.carcass.knife.extra_slices", (Object[])new Object[]{String.valueOf(ChatFormatting.AQUA) + KnifeTooltipEventHandler.formatExtraSlices(extraSlices) + String.valueOf(ChatFormatting.RESET)}));
    }

    private static String formatExtraSlices(double value) {
        if (value <= 0.0) {
            return "0";
        }
        int guaranteed = (int)Math.floor(value + 1.0E-6);
        double fractional = value - (double)guaranteed;
        if (fractional <= 1.0E-6) {
            return Integer.toString(guaranteed);
        }
        int percent = (int)Math.round(fractional * 100.0);
        percent = Math.min(99, Math.max(1, percent));
        if (guaranteed <= 0) {
            return String.format(Locale.US, "%d%%", percent);
        }
        return String.format(Locale.US, "%d +%d%%", guaranteed, percent);
    }
}

