/*
 * Decompiled with CFR 0.152.
 */
package com.joseetoon.carcass.particle;

import com.joseetoon.carcass.config.HuntingConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class CooldownMessageParticle
extends Particle {
    private final String messageText;
    private final int messageColor;
    private float visualDY = 0.0f;
    private float prevVisualDY = 0.0f;
    private float fadeout = 1.0f;
    private float prevFadeout = 1.0f;
    private final int opacity = 255;

    public CooldownMessageParticle(ClientLevel level, double x, double y, double z, String messageText, int messageColor) {
        super(level, x, y, z);
        this.messageText = messageText;
        this.messageColor = messageColor;
        this.f_107225_ = (int)((Double)HuntingConfig.COOLDOWN_MESSAGE_LIFETIME.get() * 20.0);
        this.f_107219_ = false;
        this.f_107226_ = 0.0f;
        System.out.println("[CooldownMessageParticle] Constructor called");
        System.out.println("  Text: '" + messageText + "'");
        System.out.println("  Color: 0x" + Integer.toHexString(messageColor));
        System.out.println("  Lifetime: " + this.f_107225_ + " ticks");
        System.out.println("  Position: " + x + ", " + y + ", " + z);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void m_5989_() {
        if (this.f_107224_ == 0) {
            System.out.println("[CooldownMessageParticle] First tick - age=0, lifetime=" + this.f_107225_);
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            System.out.println("[CooldownMessageParticle] Removing particle - age=" + this.f_107224_ + " >= lifetime=" + this.f_107225_);
            this.m_107274_();
        } else {
            float fadeLength = 6.0f;
            this.prevFadeout = this.fadeout;
            this.fadeout = (float)this.f_107224_ > (float)this.f_107225_ - fadeLength ? ((float)this.f_107225_ - (float)this.f_107224_) / fadeLength : 1.0f;
            this.prevVisualDY = this.visualDY;
            this.visualDY += ((Double)HuntingConfig.COOLDOWN_MESSAGE_SLIDE_SPEED.get()).floatValue();
            if (this.f_107224_ % 20 == 0) {
                System.out.println("[CooldownMessageParticle] Tick update - age=" + this.f_107224_ + " visualDY=" + this.visualDY + " fadeout=" + this.fadeout);
            }
        }
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTicks) {
        if (this.f_107224_ == 0) {
            System.out.println("[CooldownMessageParticle] render() called for first time!");
            System.out.println("  Text: '" + this.messageText + "'");
            System.out.println("  Camera pos: " + String.valueOf(camera.m_90583_()));
        }
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        Vec3 cameraPos = camera.m_90583_();
        float particleX = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
        float particleY = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_());
        float particleZ = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        poseStack.m_252880_(particleX, particleY, particleZ);
        double distanceFromCam = new Vec3((double)particleX, (double)particleY, (double)particleZ).m_82553_();
        double scaleFactor = Mth.m_14008_((double)(distanceFromCam / 32.0), (double)0.5, (double)3.0);
        float interpolatedDY = Mth.m_14179_((float)partialTicks, (float)this.prevVisualDY, (float)this.visualDY);
        poseStack.m_252880_(0.0f, interpolatedDY, 0.0f);
        float d2r = (float)Math.PI / 180;
        Quaternionf quat = new Quaternionf().rotationYXZ(camera.m_90590_() * -d2r, camera.m_90589_() * d2r, 0.0f);
        poseStack.m_252781_(quat);
        float scale = (float)(0.006 * distanceFromCam * scaleFactor);
        poseStack.m_85841_(-scale, -scale, scale);
        float interpolatedFadeout = Mth.m_14179_((float)partialTicks, (float)this.prevFadeout, (float)this.fadeout);
        Objects.requireNonNull(this);
        int alpha = (int)(255.0f * interpolatedFadeout);
        this.renderText(poseStack, bufferSource, alpha);
        poseStack.m_85849_();
        bufferSource.m_109911_();
    }

    private void renderText(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, int alpha) {
        Font font = Minecraft.m_91087_().f_91062_;
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        int textWidth = font.m_92895_(this.messageText);
        float xOffset = (float)(-textWidth) / 2.0f;
        int red = this.messageColor >> 16 & 0xFF;
        int green = this.messageColor >> 8 & 0xFF;
        int blue = this.messageColor & 0xFF;
        int colorWithAlpha = FastColor.ARGB32.m_13660_((int)alpha, (int)red, (int)green, (int)blue);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, -0.01);
        font.m_271703_(this.messageText, xOffset, 0.0f, FastColor.ARGB32.m_13660_((int)alpha, (int)20, (int)20, (int)20), false, mat, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_85849_();
        font.m_271703_(this.messageText, xOffset, 0.0f, colorWithAlpha, false, mat, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

