/*
 * Decompiled with CFR 0.152.
 */
package com.joseetoon.carcass.util;

import com.joseetoon.carcass.config.HuntingConfig;
import com.joseetoon.carcass.registry.CarcassAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class KnifeStats {
    private static Map<ResourceLocation, String> itemCategory;
    private static Map<String, Integer> categoryCooldown;
    private static Map<String, Double> categoryExtraSlices;
    private static double exhaustionPerUse;
    private static final Map<ResourceLocation, String> extraItemCategory;
    private static final Map<String, Integer> extraCategoryCooldown;
    private static final Map<String, Double> extraCategoryExtraSlices;

    private KnifeStats() {
    }

    private static void reload() {
        String cat;
        String[] parts;
        itemCategory = new HashMap<ResourceLocation, String>();
        for (String entry : (List)HuntingConfig.KNIFE_CATEGORY_ITEMS.get()) {
            String[] items;
            parts = entry.split("=");
            if (parts.length != 2) continue;
            cat = parts[0].trim();
            for (String s : items = parts[1].split(",")) {
                try {
                    ResourceLocation id = new ResourceLocation(s.trim());
                    itemCategory.put(id, cat);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        exhaustionPerUse = (Double)HuntingConfig.EXHAUSTION_PER_USE.get();
        categoryCooldown = new HashMap<String, Integer>();
        for (String entry : (List)HuntingConfig.KNIFE_CATEGORY_COOLDOWN.get()) {
            parts = entry.split("=");
            if (parts.length != 2) continue;
            try {
                cat = parts[0].trim();
                int ticks = Integer.parseInt(parts[1].trim());
                categoryCooldown.put(cat, Math.max(0, ticks));
            }
            catch (Exception cat2) {}
        }
        categoryExtraSlices = new HashMap<String, Double>();
        for (String entry : (List)HuntingConfig.KNIFE_CATEGORY_EXTRA_SLICES.get()) {
            parts = entry.split("=");
            if (parts.length != 2) continue;
            try {
                cat = parts[0].trim();
                double extra = Math.max(0.0, Double.parseDouble(parts[1].trim()));
                categoryExtraSlices.put(cat, extra);
            }
            catch (Exception exception) {}
        }
    }

    public static void invalidate() {
        itemCategory = null;
        categoryCooldown = null;
        categoryExtraSlices = null;
    }

    private static void ensureLoaded() {
        if (itemCategory == null || categoryCooldown == null || categoryExtraSlices == null) {
            KnifeStats.reload();
        }
    }

    public static int getEfficiency(ItemStack knife) {
        return 1;
    }

    public static void applyExhaustion(Player player) {
        KnifeStats.ensureLoaded();
        if (!player.m_150110_().f_35937_) {
            player.m_36399_((float)exhaustionPerUse);
        }
    }

    public static void damageKnife(ItemStack knife, Player player) {
        if (!player.m_150110_().f_35937_) {
            knife.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
        }
    }

    public static boolean isHuntersKnife(ItemStack stack) {
        KnifeStats.ensureLoaded();
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (key == null) {
            return false;
        }
        return itemCategory.containsKey(key);
    }

    public static Optional<String> getCategory(ItemStack knife) {
        KnifeStats.ensureLoaded();
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)knife.m_41720_());
        if (key == null) {
            return Optional.empty();
        }
        if (extraItemCategory.containsKey(key)) {
            return Optional.of(extraItemCategory.get(key));
        }
        return Optional.ofNullable(itemCategory.get(key));
    }

    public static int getConfiguredCooldownTicks(ItemStack knife) {
        KnifeStats.ensureLoaded();
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)knife.m_41720_());
        if (key == null) {
            return 0;
        }
        String category = extraItemCategory.getOrDefault(key, itemCategory.get(key));
        if (category == null) {
            return 0;
        }
        if (extraCategoryCooldown.containsKey(category)) {
            return Math.max(0, extraCategoryCooldown.get(category));
        }
        return Math.max(0, categoryCooldown.getOrDefault(category, 0));
    }

    public static int getCooldownTicks(ItemStack knife, @Nullable Player player) {
        AttributeInstance attribute;
        if (player != null && (attribute = player.m_21051_((Attribute)CarcassAttributes.KNIFE_COOLDOWN.get())) != null) {
            return (int)Math.max(0.0, attribute.m_22135_());
        }
        return KnifeStats.getConfiguredCooldownTicks(knife);
    }

    public static int getCooldownTicks(ItemStack knife, @Nullable Player player, boolean onButcher) {
        int baseCooldown = KnifeStats.getCooldownTicks(knife, player);
        if (onButcher) {
            return (int)((float)baseCooldown * 0.8f);
        }
        return baseCooldown;
    }

    public static int getPlayerCooldownTicks(ItemStack knife, boolean onButcher) {
        if (!((Boolean)HuntingConfig.ENABLE_PLAYER_ITEM_COOLDOWN.get()).booleanValue()) {
            return 0;
        }
        return KnifeStats.getCooldownTicks(knife, null, onButcher);
    }

    public static double getConfiguredExtraSlices(ItemStack knife) {
        KnifeStats.ensureLoaded();
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)knife.m_41720_());
        if (key == null) {
            return 0.0;
        }
        String category = extraItemCategory.getOrDefault(key, itemCategory.get(key));
        if (category == null) {
            return 0.0;
        }
        if (extraCategoryExtraSlices.containsKey(category)) {
            return Math.max(0.0, extraCategoryExtraSlices.get(category));
        }
        return Math.max(0.0, categoryExtraSlices.getOrDefault(category, 0.0));
    }

    public static double getExtraSlicesValue(ItemStack knife, @Nullable Player player) {
        AttributeInstance attribute;
        if (player != null && (attribute = player.m_21051_((Attribute)CarcassAttributes.EXTRA_SLICES.get())) != null) {
            return Math.max(0.0, attribute.m_22135_());
        }
        return KnifeStats.getConfiguredExtraSlices(knife);
    }

    public static int rollExtraSlices(ItemStack knife, @Nullable Player player, RandomSource random) {
        double value = KnifeStats.getExtraSlicesValue(knife, player);
        if (value <= 0.0) {
            return 0;
        }
        int guaranteed = (int)Math.floor(value);
        double fractional = value - (double)guaranteed;
        if (fractional > 0.0 && random != null && random.m_188500_() < fractional) {
            return guaranteed + 1;
        }
        return guaranteed;
    }

    public static void addCategoryItem(String category, ResourceLocation itemId) {
        extraItemCategory.put(itemId, category);
    }

    public static void addCategoryExtraSlices(String category, double extraSlices) {
        extraCategoryExtraSlices.put(category, Math.max(0.0, extraSlices));
    }

    public static void addCategoryCooldown(String category, int ticks) {
        extraCategoryCooldown.put(category, Math.max(0, ticks));
    }

    public static void setPlayerCooldownAttribute(@Nullable Player player, double ticks) {
        if (player == null) {
            return;
        }
        AttributeInstance attribute = player.m_21051_((Attribute)CarcassAttributes.KNIFE_COOLDOWN.get());
        if (attribute == null) {
            return;
        }
        double clamped = Math.max(-1024.0, Math.min(1024.0, ticks));
        attribute.m_22100_(clamped);
    }

    public static void setPlayerExtraSlicesAttribute(@Nullable Player player, double extraSlices) {
        if (player == null) {
            return;
        }
        AttributeInstance attribute = player.m_21051_((Attribute)CarcassAttributes.EXTRA_SLICES.get());
        if (attribute == null) {
            return;
        }
        double clamped = Math.max(0.0, Math.min(1024.0, extraSlices));
        attribute.m_22100_(clamped);
    }

    public static void clearPlayerAttributeOverrides(@Nullable Player player) {
        AttributeInstance extraSlices;
        if (player == null) {
            return;
        }
        AttributeInstance cooldown = player.m_21051_((Attribute)CarcassAttributes.KNIFE_COOLDOWN.get());
        if (cooldown != null) {
            cooldown.m_22100_(0.0);
        }
        if ((extraSlices = player.m_21051_((Attribute)CarcassAttributes.EXTRA_SLICES.get())) != null) {
            extraSlices.m_22100_(0.0);
        }
    }

    static {
        extraItemCategory = new HashMap<ResourceLocation, String>();
        extraCategoryCooldown = new HashMap<String, Integer>();
        extraCategoryExtraSlices = new HashMap<String, Double>();
    }
}

