/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.decofood.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BreadbasketBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public BreadbasketBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.WOOD).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)BreadbasketBlock.box((double)2.0, (double)0.0, (double)2.0, (double)6.0, (double)6.0, (double)3.0), (VoxelShape[])new VoxelShape[]{BreadbasketBlock.box((double)9.75, (double)0.0, (double)2.0, (double)13.75, (double)6.0, (double)3.0), BreadbasketBlock.box((double)4.0, (double)0.0, (double)4.25, (double)12.0, (double)1.0, (double)11.75), BreadbasketBlock.box((double)5.0, (double)0.0, (double)11.5, (double)10.75, (double)1.0, (double)13.0), BreadbasketBlock.box((double)5.0, (double)0.0, (double)3.0, (double)10.75, (double)1.0, (double)4.5), BreadbasketBlock.box((double)3.75, (double)0.0, (double)5.0, (double)4.0, (double)1.0, (double)11.0), BreadbasketBlock.box((double)12.0, (double)6.0, (double)7.5, (double)13.0, (double)10.0, (double)8.5), BreadbasketBlock.box((double)3.20711, (double)9.5, (double)7.5, (double)4.20711, (double)14.0, (double)8.5), BreadbasketBlock.box((double)11.79289, (double)9.5, (double)7.5, (double)12.79289, (double)14.0, (double)8.5), BreadbasketBlock.box((double)3.0, (double)6.0, (double)7.5, (double)4.0, (double)10.0, (double)8.5), BreadbasketBlock.box((double)6.18198, (double)12.18198, (double)7.5, (double)9.93198, (double)13.18198, (double)8.5), BreadbasketBlock.box((double)5.0, (double)0.0, (double)4.0, (double)8.0, (double)11.0, (double)7.0), BreadbasketBlock.box((double)8.75, (double)0.0, (double)5.75, (double)11.75, (double)11.0, (double)8.75), BreadbasketBlock.box((double)8.75, (double)0.0, (double)7.25, (double)11.75, (double)11.0, (double)10.25), BreadbasketBlock.box((double)5.0, (double)0.0, (double)9.0, (double)8.0, (double)11.0, (double)12.0), BreadbasketBlock.box((double)2.0, (double)0.0, (double)13.0, (double)6.0, (double)6.0, (double)14.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)BreadbasketBlock.box((double)10.0, (double)0.0, (double)13.0, (double)14.0, (double)6.0, (double)14.0), (VoxelShape[])new VoxelShape[]{BreadbasketBlock.box((double)2.25, (double)0.0, (double)13.0, (double)6.25, (double)6.0, (double)14.0), BreadbasketBlock.box((double)4.0, (double)0.0, (double)4.25, (double)12.0, (double)1.0, (double)11.75), BreadbasketBlock.box((double)5.25, (double)0.0, (double)3.0, (double)11.0, (double)1.0, (double)4.5), BreadbasketBlock.box((double)5.25, (double)0.0, (double)11.5, (double)11.0, (double)1.0, (double)13.0), BreadbasketBlock.box((double)12.0, (double)0.0, (double)5.0, (double)12.25, (double)1.0, (double)11.0), BreadbasketBlock.box((double)3.0, (double)6.0, (double)7.5, (double)4.0, (double)10.0, (double)8.5), BreadbasketBlock.box((double)11.79289, (double)9.5, (double)7.5, (double)12.79289, (double)14.0, (double)8.5), BreadbasketBlock.box((double)3.20711, (double)9.5, (double)7.5, (double)4.20711, (double)14.0, (double)8.5), BreadbasketBlock.box((double)12.0, (double)6.0, (double)7.5, (double)13.0, (double)10.0, (double)8.5), BreadbasketBlock.box((double)6.06802, (double)12.18198, (double)7.5, (double)9.81802, (double)13.18198, (double)8.5), BreadbasketBlock.box((double)8.0, (double)0.0, (double)9.0, (double)11.0, (double)11.0, (double)12.0), BreadbasketBlock.box((double)4.25, (double)0.0, (double)7.25, (double)7.25, (double)11.0, (double)10.25), BreadbasketBlock.box((double)4.25, (double)0.0, (double)5.75, (double)7.25, (double)11.0, (double)8.75), BreadbasketBlock.box((double)8.0, (double)0.0, (double)4.0, (double)11.0, (double)11.0, (double)7.0), BreadbasketBlock.box((double)10.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)3.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)BreadbasketBlock.box((double)2.0, (double)0.0, (double)10.0, (double)3.0, (double)6.0, (double)14.0), (VoxelShape[])new VoxelShape[]{BreadbasketBlock.box((double)2.0, (double)0.0, (double)2.25, (double)3.0, (double)6.0, (double)6.25), BreadbasketBlock.box((double)4.25, (double)0.0, (double)4.0, (double)11.75, (double)1.0, (double)12.0), BreadbasketBlock.box((double)11.5, (double)0.0, (double)5.25, (double)13.0, (double)1.0, (double)11.0), BreadbasketBlock.box((double)3.0, (double)0.0, (double)5.25, (double)4.5, (double)1.0, (double)11.0), BreadbasketBlock.box((double)5.0, (double)0.0, (double)12.0, (double)11.0, (double)1.0, (double)12.25), BreadbasketBlock.box((double)7.5, (double)6.0, (double)3.0, (double)8.5, (double)10.0, (double)4.0), BreadbasketBlock.box((double)7.5, (double)9.5, (double)11.79289, (double)8.5, (double)14.0, (double)12.79289), BreadbasketBlock.box((double)7.5, (double)9.5, (double)3.20711, (double)8.5, (double)14.0, (double)4.20711), BreadbasketBlock.box((double)7.5, (double)6.0, (double)12.0, (double)8.5, (double)10.0, (double)13.0), BreadbasketBlock.box((double)7.5, (double)12.18198, (double)6.06802, (double)8.5, (double)13.18198, (double)9.81802), BreadbasketBlock.box((double)4.0, (double)0.0, (double)8.0, (double)7.0, (double)11.0, (double)11.0), BreadbasketBlock.box((double)5.75, (double)0.0, (double)4.25, (double)8.75, (double)11.0, (double)7.25), BreadbasketBlock.box((double)7.25, (double)0.0, (double)4.25, (double)10.25, (double)11.0, (double)7.25), BreadbasketBlock.box((double)9.0, (double)0.0, (double)8.0, (double)12.0, (double)11.0, (double)11.0), BreadbasketBlock.box((double)13.0, (double)0.0, (double)10.0, (double)14.0, (double)6.0, (double)14.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)BreadbasketBlock.box((double)13.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)6.0), (VoxelShape[])new VoxelShape[]{BreadbasketBlock.box((double)13.0, (double)0.0, (double)9.75, (double)14.0, (double)6.0, (double)13.75), BreadbasketBlock.box((double)4.25, (double)0.0, (double)4.0, (double)11.75, (double)1.0, (double)12.0), BreadbasketBlock.box((double)3.0, (double)0.0, (double)5.0, (double)4.5, (double)1.0, (double)10.75), BreadbasketBlock.box((double)11.5, (double)0.0, (double)5.0, (double)13.0, (double)1.0, (double)10.75), BreadbasketBlock.box((double)5.0, (double)0.0, (double)3.75, (double)11.0, (double)1.0, (double)4.0), BreadbasketBlock.box((double)7.5, (double)6.0, (double)12.0, (double)8.5, (double)10.0, (double)13.0), BreadbasketBlock.box((double)7.5, (double)9.5, (double)3.20711, (double)8.5, (double)14.0, (double)4.20711), BreadbasketBlock.box((double)7.5, (double)9.5, (double)11.79289, (double)8.5, (double)14.0, (double)12.79289), BreadbasketBlock.box((double)7.5, (double)6.0, (double)3.0, (double)8.5, (double)10.0, (double)4.0), BreadbasketBlock.box((double)7.5, (double)12.18198, (double)6.18198, (double)8.5, (double)13.18198, (double)9.93198), BreadbasketBlock.box((double)9.0, (double)0.0, (double)5.0, (double)12.0, (double)11.0, (double)8.0), BreadbasketBlock.box((double)7.25, (double)0.0, (double)8.75, (double)10.25, (double)11.0, (double)11.75), BreadbasketBlock.box((double)5.75, (double)0.0, (double)8.75, (double)8.75, (double)11.0, (double)11.75), BreadbasketBlock.box((double)4.0, (double)0.0, (double)5.0, (double)7.0, (double)11.0, (double)8.0), BreadbasketBlock.box((double)2.0, (double)0.0, (double)2.0, (double)3.0, (double)6.0, (double)6.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)Direction.NORTH);
        }
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }
}

