/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.decofood.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class JamvariantBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public JamvariantBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.GLASS).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)JamvariantBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape[])new VoxelShape[]{JamvariantBlock.box((double)4.5, (double)8.0, (double)4.5, (double)11.5, (double)10.0, (double)11.5), JamvariantBlock.box((double)3.75, (double)8.0, (double)4.5, (double)4.75, (double)9.0, (double)11.5), JamvariantBlock.box((double)11.25, (double)8.0, (double)4.5, (double)12.25, (double)9.0, (double)11.5), JamvariantBlock.box((double)3.75, (double)8.0, (double)11.25, (double)12.25, (double)9.0, (double)12.25), JamvariantBlock.box((double)3.75, (double)8.0, (double)3.75, (double)12.25, (double)9.0, (double)4.75)});
            case Direction.NORTH -> Shapes.or((VoxelShape)JamvariantBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape[])new VoxelShape[]{JamvariantBlock.box((double)4.5, (double)8.0, (double)4.5, (double)11.5, (double)10.0, (double)11.5), JamvariantBlock.box((double)11.25, (double)8.0, (double)4.5, (double)12.25, (double)9.0, (double)11.5), JamvariantBlock.box((double)3.75, (double)8.0, (double)4.5, (double)4.75, (double)9.0, (double)11.5), JamvariantBlock.box((double)3.75, (double)8.0, (double)3.75, (double)12.25, (double)9.0, (double)4.75), JamvariantBlock.box((double)3.75, (double)8.0, (double)11.25, (double)12.25, (double)9.0, (double)12.25)});
            case Direction.EAST -> Shapes.or((VoxelShape)JamvariantBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape[])new VoxelShape[]{JamvariantBlock.box((double)4.5, (double)8.0, (double)4.5, (double)11.5, (double)10.0, (double)11.5), JamvariantBlock.box((double)4.5, (double)8.0, (double)11.25, (double)11.5, (double)9.0, (double)12.25), JamvariantBlock.box((double)4.5, (double)8.0, (double)3.75, (double)11.5, (double)9.0, (double)4.75), JamvariantBlock.box((double)11.25, (double)8.0, (double)3.75, (double)12.25, (double)9.0, (double)12.25), JamvariantBlock.box((double)3.75, (double)8.0, (double)3.75, (double)4.75, (double)9.0, (double)12.25)});
            case Direction.WEST -> Shapes.or((VoxelShape)JamvariantBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape[])new VoxelShape[]{JamvariantBlock.box((double)4.5, (double)8.0, (double)4.5, (double)11.5, (double)10.0, (double)11.5), JamvariantBlock.box((double)4.5, (double)8.0, (double)3.75, (double)11.5, (double)9.0, (double)4.75), JamvariantBlock.box((double)4.5, (double)8.0, (double)11.25, (double)11.5, (double)9.0, (double)12.25), JamvariantBlock.box((double)3.75, (double)8.0, (double)3.75, (double)4.75, (double)9.0, (double)12.25), JamvariantBlock.box((double)11.25, (double)8.0, (double)3.75, (double)12.25, (double)9.0, (double)12.25)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)Direction.NORTH);
        }
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }
}

