/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.decofood.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RiceBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public RiceBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.METAL).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)RiceBlock.box((double)12.32322, (double)0.0, (double)5.68718, (double)12.82322, (double)1.0, (double)10.18718), (VoxelShape[])new VoxelShape[]{RiceBlock.box((double)5.32322, (double)0.0, (double)2.92678, (double)10.82322, (double)3.5, (double)3.92678), RiceBlock.box((double)2.73223, (double)0.0, (double)10.18198, (double)6.73223, (double)3.5, (double)11.18198), RiceBlock.box((double)9.72487, (double)0.0, (double)4.28554, (double)13.97487, (double)3.5, (double)5.28554), RiceBlock.box((double)5.07322, (double)0.0, (double)11.93718, (double)10.82322, (double)3.5, (double)12.93718), RiceBlock.box((double)12.82843, (double)0.0, (double)5.93198, (double)13.82843, (double)3.5, (double)9.93198), RiceBlock.box((double)9.72487, (double)0.0, (double)10.57843, (double)13.97487, (double)3.5, (double)11.57843), RiceBlock.box((double)2.31802, (double)0.0, (double)5.93198, (double)3.31802, (double)3.5, (double)10.18198), RiceBlock.box((double)2.65901, (double)0.0, (double)4.7552, (double)6.90901, (double)3.5, (double)5.7552), RiceBlock.box((double)4.82322, (double)0.0, (double)3.93718, (double)11.07322, (double)1.0, (double)11.93718), RiceBlock.box((double)11.07322, (double)0.0, (double)4.43718, (double)12.32322, (double)1.0, (double)11.43718), RiceBlock.box((double)3.17678, (double)0.0, (double)5.43718, (double)4.17678, (double)1.0, (double)10.68718), RiceBlock.box((double)4.17678, (double)0.0, (double)4.43718, (double)5.42678, (double)1.0, (double)11.43718), RiceBlock.box((double)4.25, (double)1.0, (double)6.0, (double)11.75, (double)5.0, (double)10.0), RiceBlock.box((double)5.25, (double)5.0, (double)6.0, (double)10.75, (double)6.0, (double)10.0), RiceBlock.box((double)5.0, (double)0.75, (double)5.25, (double)10.5, (double)4.75, (double)6.0), RiceBlock.box((double)5.0, (double)0.75, (double)10.0, (double)10.5, (double)4.75, (double)10.75), RiceBlock.box((double)3.5, (double)1.25, (double)6.75, (double)4.25, (double)4.25, (double)9.25), RiceBlock.box((double)11.75, (double)1.25, (double)6.75, (double)12.5, (double)4.25, (double)9.25), RiceBlock.box((double)10.25, (double)2.0, (double)6.75, (double)10.75, (double)10.0, (double)7.25), RiceBlock.box((double)10.25, (double)2.0, (double)8.25, (double)10.75, (double)10.0, (double)8.75)});
            case Direction.NORTH -> Shapes.or((VoxelShape)RiceBlock.box((double)3.17678, (double)0.0, (double)5.81282, (double)3.67678, (double)1.0, (double)10.31282), (VoxelShape[])new VoxelShape[]{RiceBlock.box((double)5.17678, (double)0.0, (double)12.07322, (double)10.67678, (double)3.5, (double)13.07322), RiceBlock.box((double)9.26777, (double)0.0, (double)4.81802, (double)13.26777, (double)3.5, (double)5.81802), RiceBlock.box((double)2.02513, (double)0.0, (double)10.71446, (double)6.27513, (double)3.5, (double)11.71446), RiceBlock.box((double)5.17678, (double)0.0, (double)3.06282, (double)10.92678, (double)3.5, (double)4.06282), RiceBlock.box((double)2.17157, (double)0.0, (double)6.06802, (double)3.17157, (double)3.5, (double)10.06802), RiceBlock.box((double)2.02513, (double)0.0, (double)4.42157, (double)6.27513, (double)3.5, (double)5.42157), RiceBlock.box((double)12.68198, (double)0.0, (double)5.81802, (double)13.68198, (double)3.5, (double)10.06802), RiceBlock.box((double)9.09099, (double)0.0, (double)10.2448, (double)13.34099, (double)3.5, (double)11.2448), RiceBlock.box((double)4.92678, (double)0.0, (double)4.06282, (double)11.17678, (double)1.0, (double)12.06282), RiceBlock.box((double)3.67678, (double)0.0, (double)4.56282, (double)4.92678, (double)1.0, (double)11.56282), RiceBlock.box((double)11.82322, (double)0.0, (double)5.31282, (double)12.82322, (double)1.0, (double)10.56282), RiceBlock.box((double)10.57322, (double)0.0, (double)4.56282, (double)11.82322, (double)1.0, (double)11.56282), RiceBlock.box((double)4.25, (double)1.0, (double)6.0, (double)11.75, (double)5.0, (double)10.0), RiceBlock.box((double)5.25, (double)5.0, (double)6.0, (double)10.75, (double)6.0, (double)10.0), RiceBlock.box((double)5.5, (double)0.75, (double)10.0, (double)11.0, (double)4.75, (double)10.75), RiceBlock.box((double)5.5, (double)0.75, (double)5.25, (double)11.0, (double)4.75, (double)6.0), RiceBlock.box((double)11.75, (double)1.25, (double)6.75, (double)12.5, (double)4.25, (double)9.25), RiceBlock.box((double)3.5, (double)1.25, (double)6.75, (double)4.25, (double)4.25, (double)9.25), RiceBlock.box((double)5.25, (double)2.0, (double)8.75, (double)5.75, (double)10.0, (double)9.25), RiceBlock.box((double)5.25, (double)2.0, (double)7.25, (double)5.75, (double)10.0, (double)7.75)});
            case Direction.EAST -> Shapes.or((VoxelShape)RiceBlock.box((double)5.68718, (double)0.0, (double)3.17678, (double)10.18718, (double)1.0, (double)3.67678), (VoxelShape[])new VoxelShape[]{RiceBlock.box((double)2.92678, (double)0.0, (double)5.17678, (double)3.92678, (double)3.5, (double)10.67678), RiceBlock.box((double)10.18198, (double)0.0, (double)9.26777, (double)11.18198, (double)3.5, (double)13.26777), RiceBlock.box((double)4.28554, (double)0.0, (double)2.02513, (double)5.28554, (double)3.5, (double)6.27513), RiceBlock.box((double)11.93718, (double)0.0, (double)5.17678, (double)12.93718, (double)3.5, (double)10.92678), RiceBlock.box((double)5.93198, (double)0.0, (double)2.17157, (double)9.93198, (double)3.5, (double)3.17157), RiceBlock.box((double)10.57843, (double)0.0, (double)2.02513, (double)11.57843, (double)3.5, (double)6.27513), RiceBlock.box((double)5.93198, (double)0.0, (double)12.68198, (double)10.18198, (double)3.5, (double)13.68198), RiceBlock.box((double)4.7552, (double)0.0, (double)9.09099, (double)5.7552, (double)3.5, (double)13.34099), RiceBlock.box((double)3.93718, (double)0.0, (double)4.92678, (double)11.93718, (double)1.0, (double)11.17678), RiceBlock.box((double)4.43718, (double)0.0, (double)3.67678, (double)11.43718, (double)1.0, (double)4.92678), RiceBlock.box((double)5.43718, (double)0.0, (double)11.82322, (double)10.68718, (double)1.0, (double)12.82322), RiceBlock.box((double)4.43718, (double)0.0, (double)10.57322, (double)11.43718, (double)1.0, (double)11.82322), RiceBlock.box((double)6.0, (double)1.0, (double)4.25, (double)10.0, (double)5.0, (double)11.75), RiceBlock.box((double)6.0, (double)5.0, (double)5.25, (double)10.0, (double)6.0, (double)10.75), RiceBlock.box((double)5.25, (double)0.75, (double)5.5, (double)6.0, (double)4.75, (double)11.0), RiceBlock.box((double)10.0, (double)0.75, (double)5.5, (double)10.75, (double)4.75, (double)11.0), RiceBlock.box((double)6.75, (double)1.25, (double)11.75, (double)9.25, (double)4.25, (double)12.5), RiceBlock.box((double)6.75, (double)1.25, (double)3.5, (double)9.25, (double)4.25, (double)4.25), RiceBlock.box((double)6.75, (double)2.0, (double)5.25, (double)7.25, (double)10.0, (double)5.75), RiceBlock.box((double)8.25, (double)2.0, (double)5.25, (double)8.75, (double)10.0, (double)5.75)});
            case Direction.WEST -> Shapes.or((VoxelShape)RiceBlock.box((double)5.81282, (double)0.0, (double)12.32322, (double)10.31282, (double)1.0, (double)12.82322), (VoxelShape[])new VoxelShape[]{RiceBlock.box((double)12.07322, (double)0.0, (double)5.32322, (double)13.07322, (double)3.5, (double)10.82322), RiceBlock.box((double)4.81802, (double)0.0, (double)2.73223, (double)5.81802, (double)3.5, (double)6.73223), RiceBlock.box((double)10.71446, (double)0.0, (double)9.72487, (double)11.71446, (double)3.5, (double)13.97487), RiceBlock.box((double)3.06282, (double)0.0, (double)5.07322, (double)4.06282, (double)3.5, (double)10.82322), RiceBlock.box((double)6.06802, (double)0.0, (double)12.82843, (double)10.06802, (double)3.5, (double)13.82843), RiceBlock.box((double)4.42157, (double)0.0, (double)9.72487, (double)5.42157, (double)3.5, (double)13.97487), RiceBlock.box((double)5.81802, (double)0.0, (double)2.31802, (double)10.06802, (double)3.5, (double)3.31802), RiceBlock.box((double)10.2448, (double)0.0, (double)2.65901, (double)11.2448, (double)3.5, (double)6.90901), RiceBlock.box((double)4.06282, (double)0.0, (double)4.82322, (double)12.06282, (double)1.0, (double)11.07322), RiceBlock.box((double)4.56282, (double)0.0, (double)11.07322, (double)11.56282, (double)1.0, (double)12.32322), RiceBlock.box((double)5.31282, (double)0.0, (double)3.17678, (double)10.56282, (double)1.0, (double)4.17678), RiceBlock.box((double)4.56282, (double)0.0, (double)4.17678, (double)11.56282, (double)1.0, (double)5.42678), RiceBlock.box((double)6.0, (double)1.0, (double)4.25, (double)10.0, (double)5.0, (double)11.75), RiceBlock.box((double)6.0, (double)5.0, (double)5.25, (double)10.0, (double)6.0, (double)10.75), RiceBlock.box((double)10.0, (double)0.75, (double)5.0, (double)10.75, (double)4.75, (double)10.5), RiceBlock.box((double)5.25, (double)0.75, (double)5.0, (double)6.0, (double)4.75, (double)10.5), RiceBlock.box((double)6.75, (double)1.25, (double)3.5, (double)9.25, (double)4.25, (double)4.25), RiceBlock.box((double)6.75, (double)1.25, (double)11.75, (double)9.25, (double)4.25, (double)12.5), RiceBlock.box((double)8.75, (double)2.0, (double)10.25, (double)9.25, (double)10.0, (double)10.75), RiceBlock.box((double)7.25, (double)2.0, (double)10.25, (double)7.75, (double)10.0, (double)10.75)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)Direction.NORTH);
        }
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }
}

