/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.chunkloader;

import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.stargate.Stargate;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.common.world.ForgeChunkManager;

public class ChunkManager {
    private static final UUID JSG_CHUNKS = UUID.fromString("ebe3ef80-f613-48a8-b10d-7a28406224d1");

    public static void forceChunk(ServerLevel world, ChunkPos chunk) {
        ChunkManager.forceChunk(world, chunk, false);
    }

    public static void forceChunk(ServerLevel world, ChunkPos chunk, boolean quiet) {
        boolean forced = ForgeChunkManager.forceChunk((ServerLevel)world, (String)"jsg", (UUID)JSG_CHUNKS, (int)chunk.f_45578_, (int)chunk.f_45579_, (boolean)true, (boolean)true);
        if (!quiet && forced) {
            JSGApi.logger.debug("Forcing chunk {}, in world {}", (Object)chunk, (Object)world.m_46472_().m_135782_().toString());
        }
    }

    public static void unforceChunk(ServerLevel world, ChunkPos chunk) {
        ChunkManager.unforceChunk(world, chunk, false);
    }

    public static void unforceChunk(ServerLevel world, ChunkPos chunk, boolean quiet) {
        boolean forced = ForgeChunkManager.forceChunk((ServerLevel)world, (String)"jsg", (UUID)JSG_CHUNKS, (int)chunk.f_45578_, (int)chunk.f_45579_, (boolean)false, (boolean)true);
        if (!quiet && forced) {
            JSGApi.logger.debug("Un-forcing chunk {}, in world {}", (Object)chunk, (Object)world.m_46472_().m_135782_().toString());
        }
    }

    public static void forceChunk(Stargate<?> stargate) {
        ChunkManager.forceChunk((ServerLevel)stargate.getStargateLevel(), new ChunkPos(stargate.blockPosition()));
    }

    public static void unforceChunk(Stargate<?> stargate) {
        ChunkManager.unforceChunk((ServerLevel)stargate.getStargateLevel(), new ChunkPos(stargate.blockPosition()));
    }
}

