/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.client.LoadersHolder;
import dev.tauri.jsg.api.client.model.AbstractOBJModel;
import dev.tauri.jsg.api.registry.BiomeOverlayRegistry;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public interface IModelsHolder {
    default public void loadEntry(String texturePath, boolean byOverlay) {
        for (BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay : BiomeOverlayRegistry.values()) {
            if (!byOverlay) {
                this.getBiomeTextureResourceMap().put(biomeOverlay, this.getLoadersHolder().texture().getTextureResource(texturePath));
                continue;
            }
            String[] split = texturePath.split("\\.");
            this.getBiomeTextureResourceMap().put(biomeOverlay, this.getLoadersHolder().texture().getTextureResource(split[0] + biomeOverlay.getSuffix() + "." + split[1]));
        }
    }

    @NotNull
    public LoadersHolder getLoadersHolder();

    @NotNull
    public ResourceLocation getModelLocation();

    @NotNull
    public Map<BiomeOverlayRegistry.BiomeOverlayInstance, ResourceLocation> getBiomeTextureResourceMap();

    @NotNull
    public List<BiomeOverlayRegistry.BiomeOverlayInstance> getNonExistingTexturesReported();

    default public IModelsHolder bindTexture(BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay, ResourceLocation resourceLocation) {
        if (!this.getLoadersHolder().texture().isTextureLoaded(resourceLocation)) {
            if (!this.getNonExistingTexturesReported().contains(biomeOverlay)) {
                JSGApi.logger.error("{} tried to use BiomeOverlay {} but it doesn't exist. ({})", this, biomeOverlay.id, resourceLocation);
                this.getNonExistingTexturesReported().add(biomeOverlay);
            }
            resourceLocation = this.getBiomeTextureResourceMap().get(BiomeOverlayRegistry.NORMAL);
        }
        this.getLoadersHolder().texture().getTexture(resourceLocation).bindTexture();
        AbstractOBJModel.setActiveTexture(resourceLocation);
        return this;
    }

    default public IModelsHolder bindTexture() {
        return this.bindTexture(BiomeOverlayRegistry.NORMAL);
    }

    default public IModelsHolder bindTexture(BiomeOverlayRegistry.BiomeOverlayInstance biomeOverlay) {
        ResourceLocation resourceLocation = this.getBiomeTextureResourceMap().get(biomeOverlay);
        return this.bindTexture(biomeOverlay, resourceLocation);
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light) {
        this.render(stack, bufferSource, light, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        this.render(stack, bufferSource, light, overlay, false, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, @Nullable TextureAtlasSprite textureAtlasSprite) {
        this.render(stack, bufferSource, light, overlay, false, 1.0f, 1.0f, 1.0f, 1.0f, false, textureAtlasSprite, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, null, textureUsed);
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, @Nullable TextureAtlasSprite textureAtlasSprite) {
        this.render(stack, bufferSource, light, textureAtlasSprite, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, @Nullable TextureAtlasSprite textureAtlasSprite, boolean noCulling) {
        this.render(stack, bufferSource, light, OverlayTexture.f_118083_, false, 1.0f, 1.0f, 1.0f, 1.0f, noCulling, textureAtlasSprite, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, @Nullable TextureAtlasSprite textureAtlasSprite, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, OverlayTexture.f_118083_, false, 1.0f, 1.0f, 1.0f, 1.0f, false, textureAtlasSprite, textureUsed);
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering) {
        this.render(stack, bufferSource, light, emissiveRendering, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, emissiveRendering, null, textureUsed);
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, @Nullable TextureAtlasSprite textureAtlasSprite) {
        this.render(stack, bufferSource, light, emissiveRendering, textureAtlasSprite, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, @Nullable TextureAtlasSprite textureAtlasSprite, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, OverlayTexture.f_118083_, emissiveRendering, 1.0f, 1.0f, 1.0f, 1.0f, false, textureAtlasSprite, textureUsed);
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering) {
        this.render(stack, bufferSource, light, overlay, emissiveRendering, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, overlay, emissiveRendering, 1.0f, textureUsed);
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, float color) {
        this.render(stack, bufferSource, light, emissiveRendering, color, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, float color, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, OverlayTexture.f_118083_, emissiveRendering, color, textureUsed);
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float color) {
        this.render(stack, bufferSource, light, overlay, emissiveRendering, color, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float color, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, overlay, emissiveRendering, color, false, textureUsed);
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, float color, boolean noCulling) {
        this.render(stack, bufferSource, light, emissiveRendering, color, noCulling, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, boolean emissiveRendering, float color, boolean noCulling, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, OverlayTexture.f_118083_, emissiveRendering, color, noCulling, textureUsed);
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float color, boolean noCulling) {
        this.render(stack, bufferSource, light, overlay, emissiveRendering, color, noCulling, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack stack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float color, boolean noCulling, @Nullable ResourceLocation textureUsed) {
        this.render(stack, bufferSource, light, overlay, emissiveRendering, color, color, color, 1.0f, noCulling, textureUsed);
    }

    default public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling) {
        this.render(poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable ResourceLocation textureUsed) {
        this.render(poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, null, textureUsed);
    }

    default public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable TextureAtlasSprite textureAtlasSprite) {
        this.render(poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, textureAtlasSprite, AbstractOBJModel.getActiveTexture());
    }

    default public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable TextureAtlasSprite textureAtlasSprite, @Nullable ResourceLocation textureUsed) {
        this.render(AbstractOBJModel.getRenderMethod(), poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, textureAtlasSprite, textureUsed);
    }

    default public void render(AbstractOBJModel.EnumOBJRenderMethod renderType, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling) {
        this.render(renderType, poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, AbstractOBJModel.getActiveTexture());
    }

    default public void render(AbstractOBJModel.EnumOBJRenderMethod renderType, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable ResourceLocation textureUsed) {
        this.render(renderType, poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, null, textureUsed);
    }

    default public void render(AbstractOBJModel.EnumOBJRenderMethod renderType, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable TextureAtlasSprite textureAtlasSprite) {
        this.render(renderType, poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, textureAtlasSprite, AbstractOBJModel.getActiveTexture());
    }

    default public void render(AbstractOBJModel.EnumOBJRenderMethod renderType, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable TextureAtlasSprite textureAtlasSprite, @Nullable ResourceLocation textureUsed) {
        this.getLoadersHolder().model().getModel(this.getModelLocation()).render(renderType, poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, textureAtlasSprite, textureUsed);
    }
}

