/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.client;

import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.client.model.IModelLoader;
import dev.tauri.jsg.api.client.texture.ITextureLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.loading.progress.ProgressMeter;

public class LoadersHolder {
    private final ITextureLoader textureLoader;
    private final IModelLoader modelLoader;
    private final String modId;
    private static final Map<String, LoadersHolder> HOLDERS = new HashMap<String, LoadersHolder>();
    public static final LoadersHolder JSG_HOLDER = LoadersHolder.getOrCreate("jsg", JSGApi.jsgModMainClass);

    public LoadersHolder(String modId, ITextureLoader textureLoader, IModelLoader modelLoader) {
        this.modId = modId;
        this.textureLoader = textureLoader;
        this.modelLoader = modelLoader;
    }

    public ITextureLoader texture() {
        if (this.textureLoader == null) {
            throw new UnsupportedOperationException("Can note get texture loader for mod " + this.modId);
        }
        return this.textureLoader;
    }

    public IModelLoader model() {
        if (this.modelLoader == null) {
            throw new UnsupportedOperationException("Can note get model loader for mod " + this.modId);
        }
        return this.modelLoader;
    }

    public static LoadersHolder getOrCreate(String modId, Class<?> mainModClass) {
        if (LoadersHolder.getHolder(modId).isEmpty()) {
            LoadersHolder.registerHolder(modId, JSGApi.loadersHolderGetter.get().apply(modId, mainModClass));
        }
        return HOLDERS.get(modId);
    }

    public static void registerHolder(String modId, LoadersHolder holder) {
        HOLDERS.put(modId, holder);
    }

    public static Optional<LoadersHolder> getHolder(String modId) {
        return Optional.ofNullable(HOLDERS.get(modId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(ProfilerFiller profilerFiller) {
        Map<String, LoadersHolder> map = HOLDERS;
        synchronized (map) {
            for (Map.Entry<String, LoadersHolder> e : HOLDERS.entrySet()) {
                int count;
                String id = e.getKey();
                ITextureLoader t = e.getValue().textureLoader;
                IModelLoader m = e.getValue().modelLoader;
                int n = t == null ? (m == null ? 0 : 1) : (count = m == null ? 1 : 2);
                if (count < 1) continue;
                AtomicReference<String> modName = new AtomicReference<String>(id);
                ModList.get().getModContainerById(id).ifPresentOrElse(container -> modName.set(container.getModInfo().getDisplayName()), () -> {});
                profilerFiller.m_7242_();
                profilerFiller.m_6180_("jsg_resources_" + id);
                ProgressMeter progress = StartupMessageManager.addProgressBar((String)(modName.get() + " - TESR loading"), (int)count);
                if (t != null) {
                    t.loadTextures();
                    progress.increment();
                }
                if (m != null) {
                    m.loadModels();
                    progress.increment();
                }
                progress.complete();
                profilerFiller.m_7238_();
                profilerFiller.m_7241_();
            }
        }
        if (JSGApi.jsgPointOfOriginsLoader != null) {
            profilerFiller.m_7242_();
            profilerFiller.m_6180_("jsg_point_of_origins");
            ProgressMeter progress = StartupMessageManager.addProgressBar((String)"Just Stargate Mod - Point of origins", (int)JSGApi.jsgPointOfOriginsLoader.getTotalCount());
            JSGApi.jsgPointOfOriginsLoader.loadResources(progress);
            progress.complete();
            profilerFiller.m_7238_();
            profilerFiller.m_7241_();
        }
    }
}

