/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import dev.tauri.jsg.api.client.model.AbstractOBJModel;
import dev.tauri.jsg.api.util.vectors.Vector2f;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public abstract class IOBJModelRenderer<OBJ extends AbstractOBJModel> {
    public final OBJ model;
    protected final Map<TextureAtlasSprite, VertexBuffer> modelBuffers = new HashMap<TextureAtlasSprite, VertexBuffer>();
    protected VertexBuffer modelBufferNoAtlas;

    public IOBJModelRenderer(OBJ model) {
        this.model = model;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean emissiveRendering, float r, float g, float b, float a, boolean noCulling, @Nullable TextureAtlasSprite textureAtlasSprite, @Nullable ResourceLocation textureUsed) {
        if (((AbstractOBJModel)this.model).isEmpty()) {
            return;
        }
        VertexBuffer buffer = this.initModel(poseStack, bufferSource, light, overlay, emissiveRendering, textureAtlasSprite, textureUsed);
        this.renderModel(buffer, poseStack, bufferSource, light, overlay, emissiveRendering, r, g, b, a, noCulling, textureAtlasSprite, textureUsed);
    }

    @NotNull
    public static Vector2f getCorrectUVWithSprite(float u, float v, @Nullable TextureAtlasSprite textureAtlasSprite) {
        Vector2f uv1 = new Vector2f(u, v);
        if (textureAtlasSprite != null) {
            float u0 = textureAtlasSprite.m_118409_();
            float u1 = textureAtlasSprite.m_118410_();
            float v0 = textureAtlasSprite.m_118411_();
            float v1 = textureAtlasSprite.m_118412_();
            float e = 0.001f;
            float sizeU = u1 - u0 - e;
            float sizeV = v1 - v0 - e;
            uv1 = new Vector2f(u1 - sizeU * uv1.x - e, v1 + sizeV * uv1.y - e);
        }
        return uv1;
    }

    @Nullable
    protected abstract VertexBuffer initModel(PoseStack var1, MultiBufferSource var2, int var3, int var4, boolean var5, @Nullable TextureAtlasSprite var6, @Nullable ResourceLocation var7);

    protected abstract void renderModel(@Nullable VertexBuffer var1, PoseStack var2, MultiBufferSource var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11, @Nullable TextureAtlasSprite var12, @Nullable ResourceLocation var13);
}

