/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.util.blockentity.ILinkableBE;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public interface LinkableRenderer {
    default public void renderLink(BlockPos pos, Object source, PoseStack stack, MultiBufferSource bufferSource) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (!JSGConfig.Debug.renderBoundingBoxes.get() && !Minecraft.m_91087_().m_91290_().m_114377_()) {
            return;
        }
        Level level = Minecraft.m_91087_().f_91074_.m_9236_();
        if (!(source instanceof ILinkableBE)) {
            return;
        }
        ILinkableBE linkable = (ILinkableBE)source;
        BlockPos linked = linkable.getLinkedPos();
        if (linked == null) {
            return;
        }
        BlockEntity linkedTile = level.m_7702_(linked);
        Vec3 relative = linked.m_121996_((Vec3i)pos).m_252807_();
        stack.m_85836_();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix = stack.m_85850_().m_252922_();
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_269399_((double)6.0));
        vertexconsumer.m_252986_(matrix, 0.5f, 0.5f, 0.5f).m_85950_(0.09411765f, 0.6627451f, 0.0f, 1.0f).m_5752_();
        vertexconsumer.m_252986_(matrix, (float)relative.f_82479_, (float)relative.f_82480_, (float)relative.f_82481_).m_85950_(0.0f, 0.13333334f, 0.6627451f, 1.0f).m_5752_();
        Vec3 relativeNormal = relative.m_82541_();
        double titleX = 0.5 + relativeNormal.f_82479_ * 1.5;
        double titleY = 0.5 + relativeNormal.f_82480_ * 1.5 + (double)(0.25f * (float)(relative.f_82480_ > 0.0 ? 1 : -1));
        double titleZ = 0.5 + relativeNormal.f_82481_ * 1.5;
        String sourceName = linkable.getClass().getName();
        String targetName = linkedTile == null ? "null" : linkedTile.getClass().getName();
        sourceName = sourceName.split("\\.")[sourceName.split("\\.").length - 1];
        targetName = targetName.split("\\.")[targetName.split("\\.").length - 1];
        this.renderTitle((Component)Component.m_237113_((String)("Link: " + sourceName + " - " + targetName)), new Vec3(titleX, titleY, titleZ), 1.0f, stack, bufferSource, 0.09411765f, 0.6627451f, 0.0f);
        stack.m_85849_();
    }

    private void renderTitle(Component title, Vec3 pos, float scale, PoseStack stack, MultiBufferSource bufferSource, float r, float g, float b) {
        if (bufferSource == null) {
            return;
        }
        if (title == null) {
            return;
        }
        stack.m_85836_();
        stack.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        stack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        stack.m_85841_(-0.025f * (scale *= 0.4f), -0.025f * scale, 0.025f * scale);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        float backgroundOpacityConfig = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int backgroundOpacity = (int)(backgroundOpacityConfig * 255.0f) << 24;
        Font font = Minecraft.m_91087_().f_91062_;
        float x = -font.m_92852_((FormattedText)title) / 2;
        int color = (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
        font.m_272077_(title, x, 0.0f, 0x20FFFFFF, false, matrix4f, bufferSource, Font.DisplayMode.SEE_THROUGH, backgroundOpacity, 0xF000F0);
        font.m_272077_(title, x, 0.0f, color, false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        stack.m_85849_();
    }
}

