/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.client.screen.widget.base.JSGButton;
import dev.tauri.jsg.api.client.texture.ITexture;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ModeButton
extends JSGButton {
    public final int textureWidth;
    public final int textureHeight;
    protected final ResourceLocation texture;
    public int states;
    public Map<Integer, Boolean> enabled = new HashMap<Integer, Boolean>();
    protected int currentState = 0;

    public ModeButton(int buttonId, int x, int y, int size, ResourceLocation texture, int textureWidth, int textureHeight, int states) {
        this(buttonId, x, y, size, size, texture, textureWidth, textureHeight, states);
    }

    public ModeButton(int buttonId, int x, int y, int width, int height, ResourceLocation texture, int textureWidth, int textureHeight, int states) {
        super(buttonId, x, y, width, height, "");
        this.textureHeight = textureHeight;
        this.textureWidth = textureWidth;
        this.states = states;
        this.texture = texture;
        for (int i = 0; i < states; ++i) {
            this.enabled.put(i, true);
        }
    }

    public void setStates(int i) {
        this.states = i;
    }

    public void drawButton(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.f_93624_) {
            this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
            graphics.m_280168_().m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            ITexture.bindTextureWithMc(this.texture);
            if (!this.isEnabledCurrent()) {
                GuiHelper.drawModalRectWithCustomSizedTexture(this.m_252754_(), this.m_252907_(), this.f_93618_ * 2, this.f_93619_, this.f_93618_, this.f_93619_, this.textureWidth, this.textureHeight);
            } else if (this.f_93622_) {
                GuiHelper.drawModalRectWithCustomSizedTexture(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_, this.textureWidth, this.textureHeight);
            } else {
                GuiHelper.drawModalRectWithCustomSizedTexture(this.m_252754_(), this.m_252907_(), 0.0f, this.f_93619_, this.f_93618_, this.f_93619_, this.textureWidth, this.textureHeight);
            }
            GuiHelper.drawModalRectWithCustomSizedTexture(this.m_252754_(), this.m_252907_(), this.currentState * this.f_93618_, 0.0f, this.f_93618_, this.f_93619_, this.textureWidth, this.textureHeight);
            RenderSystem.disableBlend();
            graphics.m_280168_().m_85849_();
        }
    }

    public void nextState() {
        this.currentState = this.currentState == this.states - 1 ? 0 : ++this.currentState;
    }

    public void previousState() {
        this.currentState = this.currentState == 0 ? this.states - 1 : --this.currentState;
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (GuiHelper.isPointInRegion(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, mouseX, mouseY)) {
            switch (mouseButton) {
                case 0: {
                    this.nextState();
                    break;
                }
                case 1: {
                    this.previousState();
                    break;
                }
                case 2: {
                    this.setCurrentState(0);
                }
            }
            this.m_7435_(Minecraft.m_91087_().m_91106_());
        }
    }

    public boolean isEnabledCurrent() {
        return this.enabled.get(this.currentState);
    }

    public void setEnabled(int state, boolean enabled) {
        this.enabled.put(state, enabled);
    }

    public void mouseClickedPerformAction(int mouseX, int mouseY, int mouseButton) {
        if (GuiHelper.isPointInRegion(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, mouseX, mouseY)) {
            switch (mouseButton) {
                case 0: {
                    if (!this.isEnabledCurrent()) break;
                    this.performAction();
                    break;
                }
                case 1: {
                    this.nextState();
                    break;
                }
                case 2: {
                    this.setCurrentState(0);
                }
            }
            this.m_7435_(Minecraft.m_91087_().m_91106_());
        }
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(int currentState) {
        if (currentState < 0) {
            currentState = 0;
        }
        if (currentState >= this.states) {
            currentState = this.states - 1;
        }
        this.currentState = currentState;
    }
}

