/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.config.ingame;

import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.config.ingame.BEConfigOptionProvider;
import dev.tauri.jsg.api.config.ingame.IBEConfigOption;
import dev.tauri.jsg.api.config.ingame.option.ConfigOptionsHolder;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class BEConfig
implements INBTSerializable<CompoundTag> {
    protected final ConfigOptionsHolder optionsHolder;
    protected final LinkedHashMap<String, IBEConfigOption<?>> options = new LinkedHashMap();
    protected final Runnable onChanged;

    public BEConfig() {
        this(() -> {}, ConfigOptionsHolder.EMPTY);
    }

    public BEConfig(Runnable onChanged, @NotNull ConfigOptionsHolder optionsHolder) {
        this.optionsHolder = optionsHolder;
        this.onChanged = onChanged;
        optionsHolder.init(this.onChanged, this.options);
    }

    public LinkedHashMap<String, IBEConfigOption<?>> getOptions() {
        return this.options;
    }

    public ConfigOptionsHolder getOptionsHolder() {
        return this.optionsHolder;
    }

    public <T> boolean wasValueChanged(@NotNull BEConfigOptionProvider<T> provider) {
        return this.getOption(provider).map(IBEConfigOption::isChanged).orElse(false);
    }

    public <T> Optional<T> getValue(@NotNull BEConfigOptionProvider<T> provider) {
        return this.getOption(provider).flatMap(option -> this.getOptionsHolder().parseOptionValue(provider, option.getValue()));
    }

    public <T> T getValueOrDefault(@NotNull BEConfigOptionProvider<T> provider) {
        return this.getValue(provider).orElse(provider.getStaticInstance().getDefaultValue());
    }

    public Optional<IBEConfigOption<?>> getOption(@NotNull BEConfigOptionProvider<?> provider) {
        return this.getOption(provider.getId());
    }

    public Optional<IBEConfigOption<?>> getOption(String id) {
        return Optional.ofNullable(this.options.get(id));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.options.size());
        this.options.forEach((s, option) -> {
            buf.writeInt(s.length());
            buf.writeCharSequence((CharSequence)s, StandardCharsets.UTF_8);
            option.toBytes(buf);
        });
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            int idLength = buf.readInt();
            String id = buf.readCharSequence(idLength, StandardCharsets.UTF_8).toString();
            Optional.ofNullable(this.options.get(id)).ifPresentOrElse(option -> option.fromBytes(buf), () -> {
                JSGApi.logger.error("Invalid option id '{}'", (Object)id);
                throw new IllegalArgumentException("Unknown option: " + id);
            });
        }
    }

    public final CompoundTag serializeNBT() {
        return this.serializeNBT(new CompoundTag());
    }

    public CompoundTag serializeNBT(@NotNull CompoundTag compound) {
        this.options.forEach((id, option) -> {
            if (!option.isChanged()) {
                return;
            }
            option.serializeToNBT((String)id, compound);
        });
        return compound;
    }

    public void deserializeNBT(@NotNull CompoundTag compound) {
        Set ids = compound.m_128431_();
        ids.forEach(id -> Optional.ofNullable(this.options.get(id)).ifPresent(option -> option.deserializeFromNBT((String)id, compound)));
    }
}

