/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.config.ingame;

import dev.tauri.jsg.api.client.screen.util.GuiHelper;
import dev.tauri.jsg.api.config.ingame.BEConfig;
import dev.tauri.jsg.api.config.ingame.IBEConfigOption;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public abstract class BEConfigOptionWidget<T>
extends AbstractWidget {
    public static final int TITLE_HEIGHT = 12;
    protected IBEConfigOption<T> configOption;
    protected BEConfig config;
    protected String optionId;

    public BEConfigOptionWidget(BEConfig config, String optionId, IBEConfigOption<T> configOption, int pWidth, int pHeight, Component pMessage) {
        super(0, 0, pWidth, pHeight + 12, pMessage);
        this.configOption = configOption;
        this.config = config;
        this.optionId = optionId;
    }

    public void onValueChangedByUser(T newValue) {
        this.config.getOption(this.optionId).ifPresent(option -> {
            if (option.parseAndSetValue(newValue)) {
                option.setChanged();
            }
        });
    }

    public Component getComment() {
        return Component.m_237115_((String)("gui.jsg.ingame_config." + this.optionId + ".comment"));
    }

    public Component getTitle() {
        return Component.m_237115_((String)("gui.jsg.ingame_config." + this.optionId + ".title"));
    }

    protected void m_87963_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderTitle(pGuiGraphics);
    }

    public void renderTitle(GuiGraphics graphics) {
        GuiHelper.renderScrollingStringLeftAligned(graphics, Minecraft.m_91087_().f_91062_, this.getTitle(), this.m_252754_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + 2, 0xFFFFFF, true);
    }

    public abstract String getDefaultValueToDisplay();

    public int getTitleHeight() {
        return 12;
    }

    public void renderFg(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.m_274382_()) {
            graphics.m_280666_(Minecraft.m_91087_().f_91062_, List.of(this.getComment(), Component.m_237119_(), Component.m_237110_((String)"gui.jsg.ingame_config.default_value", (Object[])new Object[]{this.getDefaultValueToDisplay()}).m_130948_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}))), mouseX, mouseY);
        }
    }

    public boolean m_93680_(double pMouseX, double pMouseY) {
        return super.m_93680_(pMouseX, pMouseY);
    }

    @ParametersAreNonnullByDefault
    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }
}

