/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.config.ingame.option;

import dev.tauri.jsg.api.config.ingame.BEConfigOptionProvider;
import dev.tauri.jsg.api.config.ingame.IBEConfigOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ConfigOptionsHolder {
    public static final ConfigOptionsHolder EMPTY = new ConfigOptionsHolder();
    protected final LinkedHashMap<String, BEConfigOptionProvider<?>> providers = new LinkedHashMap();

    public ConfigOptionsHolder() {
    }

    public ConfigOptionsHolder(@NotNull ConfigOptionsHolder holder) {
        this.copy(holder);
    }

    public <T> BEConfigOptionProvider<T> register(String id, Function<Runnable, IBEConfigOption<T>> supplier) {
        BEConfigOptionProvider<T> provider = new BEConfigOptionProvider<T>(id, supplier);
        this.providers.put(id, provider);
        return provider;
    }

    public void copy(ConfigOptionsHolder holder) {
        holder.providers.forEach((id, provider) -> this.register((String)id, provider::create));
    }

    public void init(Runnable onChanged, Map<String, IBEConfigOption<?>> targetMap) {
        targetMap.clear();
        this.providers.forEach((id, provider) -> targetMap.put((String)id, provider.create(onChanged)));
    }

    public <T> Optional<T> parseOptionValue(BEConfigOptionProvider<T> provider, Object value) {
        return provider.getStaticInstance().parseValue(value);
    }
}

