/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.config.ingame.option.type;

import dev.tauri.jsg.api.config.ingame.IBEConfigOption;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBEConfigOption<T>
implements IBEConfigOption<T> {
    @NotNull
    protected final T defaultValue;
    protected T value;
    protected boolean isModifiedByUser;
    protected final Runnable onChanged;

    public AbstractBEConfigOption(Runnable onChanged, @NotNull T defaultValue) {
        this.defaultValue = defaultValue;
        this.onChanged = onChanged;
    }

    @Override
    public boolean isChanged() {
        return this.isModifiedByUser;
    }

    @Override
    public void setChanged() {
        this.isModifiedByUser = true;
        this.onChanged.run();
    }

    @Override
    @NotNull
    public T getValue() {
        return Optional.ofNullable(this.value).orElse(this.defaultValue);
    }

    @Override
    @NotNull
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isModifiedByUser);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.isModifiedByUser = buf.readBoolean();
    }

    @Override
    public void serializeToNBT(String selfId, CompoundTag tag) {
    }

    @Override
    public void deserializeFromNBT(String selfId, CompoundTag tag) {
        this.isModifiedByUser = true;
    }
}

