/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.config.ingame.option.type;

import dev.tauri.jsg.api.config.ingame.BEConfig;
import dev.tauri.jsg.api.config.ingame.BEConfigOptionWidget;
import dev.tauri.jsg.api.config.ingame.option.type.AbstractBEConfigOption;
import dev.tauri.jsg.api.config.ingame.widget.EnumBEConfigOptionWidget;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumLikeBEConfigOption<T>
extends AbstractBEConfigOption<T> {
    protected final Supplier<T[]> valuesSupplier;
    protected final Function<Object, T> parser;
    protected final Function<T, String> toStringFunction;
    protected final BiConsumer<ByteBuf, @NotNull T> toBytesConsumer;
    protected final Function<ByteBuf, @NotNull T> fromBytesConsumer;

    @ParametersAreNonnullByDefault
    public EnumLikeBEConfigOption(Runnable onChanged, T defaultValue, Supplier<T[]> valuesSupplier, Function<Object, T> parser, Function<@NotNull T, String> toStringFunction, BiConsumer<ByteBuf, @NotNull T> toBytesConsumer, Function<ByteBuf, @NotNull T> fromBytesConsumer) {
        super(onChanged, defaultValue);
        this.valuesSupplier = valuesSupplier;
        this.parser = parser;
        this.toStringFunction = toStringFunction;
        this.toBytesConsumer = toBytesConsumer;
        this.fromBytesConsumer = fromBytesConsumer;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public BEConfigOptionWidget<T> createGUIWidget(BEConfig config, int tabWidth, String optionId) {
        return new EnumBEConfigOptionWidget(config, optionId, tabWidth, this);
    }

    @Override
    @NotNull
    public Optional<T> parseValue(Object value) {
        return Optional.ofNullable(this.parser.apply(value));
    }

    public T[] values() {
        return this.valuesSupplier.get();
    }

    public String name(@NotNull T value) {
        return this.toStringFunction.apply(value);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        this.toBytesConsumer.accept(buf, (ByteBuf)this.getValue());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.setValue(this.fromBytesConsumer.apply(buf));
    }

    @Override
    public void serializeToNBT(String selfId, CompoundTag tag) {
        ByteBuf buf = Unpooled.buffer();
        this.toBytes(buf);
        byte[] dst = new byte[buf.readableBytes()];
        buf.readBytes(dst);
        tag.m_128382_(selfId, dst);
        super.serializeToNBT(selfId, tag);
    }

    @Override
    public void deserializeFromNBT(String selfId, CompoundTag tag) {
        byte[] dst = tag.m_128463_(selfId);
        if (dst.length > 0) {
            ByteBuf buf = Unpooled.copiedBuffer((byte[])dst);
            this.fromBytes(buf);
        }
        super.deserializeFromNBT(selfId, tag);
    }
}

