/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.helper;

import dev.tauri.jsg.api.JSGApi;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class DimensionsHelper {
    public static ServerLevel getLevel(ResourceKey<Level> dim) {
        return JSGApi.currentServer.m_129880_(dim);
    }

    public static ResourceKey<Level> getDimension(ResourceLocation rl) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)rl);
    }

    public static List<ResourceKey<Level>> getDims() {
        ArrayList<ResourceKey<Level>> list = new ArrayList<ResourceKey<Level>>();
        JSGApi.currentServer.m_129785_().forEach(e -> list.add(e.m_46472_()));
        return list;
    }

    public static BlockPos getTopBlockWithPos(ServerLevel level, int x, int z, int structureX, int structureZ) {
        int startY = 255;
        if (level.m_46472_() == Level.f_46429_) {
            startY = 110;
        } else {
            structureX = 1;
            structureZ = 1;
        }
        for (int offX = 0; offX < 4; ++offX) {
            for (int offZ = 0; offZ < 4; ++offZ) {
                boolean foundAir = false;
                int minHeight = Integer.MAX_VALUE;
                int countHeights = 0;
                int sumHeights = 0;
                int hillCoef = 0;
                for (int i = 0; i < structureX; ++i) {
                    block3: for (int j = 0; j < structureZ; ++j) {
                        int currentX = x + offX * structureX + i;
                        int currentZ = z + offZ * structureZ + j;
                        level.m_8904_().m_27056_((LevelReader)level, new BlockPos(currentX, startY, currentZ), 128);
                        for (int y = startY; y > 0; --y) {
                            if (level.m_8055_(new BlockPos(currentX, y, currentZ)).m_247087_()) {
                                if (level.m_8055_(new BlockPos(currentX, y, currentZ)).m_278721_()) continue block3;
                                foundAir = true;
                                continue;
                            }
                            if (!foundAir) continue;
                            sumHeights = countHeights == 0 ? y : (sumHeights += y);
                            ++countHeights;
                            if ((double)sumHeights / (double)countHeights - (double)y > 3.0) {
                                ++hillCoef;
                            }
                            if (y >= minHeight) continue block3;
                            minHeight = y;
                            continue block3;
                        }
                    }
                }
                if (hillCoef > 5) continue;
                int currentX = x + offX * structureX;
                int currentZ = z + offZ * structureZ;
                return new BlockPos(currentX, minHeight + 1, currentZ);
            }
        }
        return new BlockPos(x, 255, z);
    }
}

