/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.integration;

import java.util.ArrayList;
import java.util.List;

public enum Integrations {
    OC2("OpenComputers", List.of("oc2", "oc2r")),
    CCT("ComputerCraft", List.of("computercraft")),
    CREATE("Create", List.of("create")),
    JEI("JEI", List.of("jei")),
    EMBEDDIUM("Embeddium", List.of("embeddium", "sodium", "rubiddium")),
    OCULUS("Embeddium", List.of("iris", "oculus")),
    STELLAR_VIEW("Stellar View", List.of("stellarview")),
    TCONSTRUCT("Tinkers Construct", List.of("tconstruct"));

    public final String name;
    public final List<String> modNames;
    public Boolean isLoaded = null;
    public final List<Loader> onLoad = new ArrayList<Loader>();
    public final List<Loader> onNotLoaded = new ArrayList<Loader>();

    private Integrations(String name, List<String> modNames) {
        this.name = name;
        this.modNames = modNames;
    }

    public boolean isLoaded() {
        return this.isLoaded != null && this.isLoaded != false;
    }

    public Integrations addOnLoad(Loader task) {
        if (this.isLoaded()) {
            try {
                task.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }
        this.onLoad.add(task);
        return this;
    }

    public Integrations addOnNotLoaded(Loader task) {
        if (this.isLoaded != null && !this.isLoaded.booleanValue()) {
            try {
                task.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }
        this.onNotLoaded.add(task);
        return this;
    }

    public static interface Loader {
        public void run() throws Exception;
    }
}

