/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.packet;

import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.packet.JSGPacket;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class SimplePacketHandler {
    public final String networkVersion;
    public final SimpleChannel channelInstance;
    public final ResourceLocation channelName;

    public SimplePacketHandler(ResourceLocation channel, String version) {
        this.networkVersion = version;
        this.channelName = channel;
        this.channelInstance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channel).clientAcceptedVersions(v -> Objects.equals(v, this.networkVersion)).serverAcceptedVersions(v -> Objects.equals(v, this.networkVersion)).networkProtocolVersion(() -> this.networkVersion).simpleChannel();
    }

    public void sendToServer(Object packet) {
        this.channelInstance.send(PacketDistributor.SERVER.noArg(), packet);
    }

    public void sendToClient(Object packet, PacketDistributor.TargetPoint point) {
        if (point == null) {
            return;
        }
        this.channelInstance.send(PacketDistributor.NEAR.with(() -> point), packet);
    }

    public void sendTo(Object packet, ServerPlayer player) {
        if (player == null) {
            return;
        }
        this.channelInstance.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    public <MSG extends JSGPacket> void registerPacket(Class<MSG> clazz, int id, NetworkDirection direction, Function<FriendlyByteBuf, MSG> decoder) {
        try {
            this.channelInstance.messageBuilder(clazz, id, direction).encoder(JSGPacket::toBytes).decoder(decoder).consumerNetworkThread(JSGPacket::handleSupplier).add();
        }
        catch (Exception e) {
            JSGApi.logger.error("Could not register packet {} for channel {}: ", id, this.channelName, e);
        }
    }
}

