/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.pointoforigins;

import dev.tauri.jsg.api.JSGApi;
import dev.tauri.jsg.api.pointoforigins.IPointOfOriginType;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraftforge.common.util.INBTSerializable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class PointOfOrigin
implements StringRepresentable,
INBTSerializable<CompoundTag> {
    public final ResourceLocation id;
    public final IPointOfOriginType forType;

    @Nullable
    public static PointOfOrigin fromNBT(CompoundTag compound, @Nullable Supplier<PointOfOrigin> fallback) {
        ResourceLocation id = new ResourceLocation(compound.m_128461_("id"));
        String namespace = compound.m_128461_("namespace");
        Optional<IPointOfOriginType> type = JSGApi.jsgPointOfOriginsLoader.getPoOType(namespace);
        if (type.isEmpty()) {
            return fallback == null ? null : fallback.get();
        }
        return JSGApi.jsgPointOfOriginsLoader.getOriginByIdOrElse(type.get(), id, fallback);
    }

    @Nullable
    public static PointOfOrigin fromBytes(FriendlyByteBuf buf, @Nullable Supplier<PointOfOrigin> fallback) {
        ResourceLocation id = buf.m_130281_();
        int size = buf.readInt();
        String namespace = String.valueOf(buf.readCharSequence(size, StandardCharsets.UTF_8));
        Optional<IPointOfOriginType> type = JSGApi.jsgPointOfOriginsLoader.getPoOType(namespace);
        if (type.isEmpty()) {
            return fallback == null ? null : fallback.get();
        }
        return JSGApi.jsgPointOfOriginsLoader.getOriginByIdOrElse(type.get(), id, fallback);
    }

    public PointOfOrigin(ResourceLocation id, IPointOfOriginType forType) {
        this.id = id;
        this.forType = forType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PointOfOrigin)) {
            return false;
        }
        PointOfOrigin origin = (PointOfOrigin)o;
        return origin.id.equals((Object)this.id);
    }

    public int hashCode() {
        return this.id.hashCode() * 31;
    }

    public String m_7912_() {
        return this.id.toString();
    }

    public ResourceLocation getPath(String variant, boolean model) {
        return new ResourceLocation(this.id.m_135827_(), (model ? "models" : "textures") + "/point_of_origins/" + this.forType.getPoONamespaceIdentifier() + "/" + this.id.m_135815_() + "/" + variant);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("id", this.id.toString());
        compound.m_128359_("namespace", this.forType.getPoONamespaceIdentifier());
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
        buf.writeInt(this.forType.getPoONamespaceIdentifier().length());
        buf.writeCharSequence((CharSequence)this.forType.getPoONamespaceIdentifier(), StandardCharsets.UTF_8);
    }
}

