/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.power.general;

import dev.tauri.jsg.api.config.JSGConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public class EnergyRequiredToOperate
implements INBTSerializable<CompoundTag> {
    public int energyToOpen;
    public int keepAlive;

    public EnergyRequiredToOperate(int energyToOpen, int keepAlive) {
        this.energyToOpen = energyToOpen;
        this.keepAlive = keepAlive;
    }

    public static EnergyRequiredToOperate stargate() {
        return new EnergyRequiredToOperate(JSGConfig.Stargate.openingBlockToEnergyRatio.get(), JSGConfig.Stargate.keepAliveBlockToEnergyRatioPerTick.get());
    }

    public static EnergyRequiredToOperate free() {
        return new EnergyRequiredToOperate(0, 0);
    }

    public EnergyRequiredToOperate(double energyToOpen, double keepAlive) {
        this((int)energyToOpen, (int)keepAlive);
    }

    public String toString() {
        return "[open=" + this.energyToOpen + ", keepAlive=" + this.keepAlive + "]";
    }

    public EnergyRequiredToOperate mul(double mul) {
        return new EnergyRequiredToOperate((double)this.energyToOpen * mul, (double)this.keepAlive * mul);
    }

    public EnergyRequiredToOperate add(EnergyRequiredToOperate add) {
        return new EnergyRequiredToOperate(this.energyToOpen + add.energyToOpen, this.keepAlive + add.keepAlive);
    }

    public EnergyRequiredToOperate cap(int max) {
        return new EnergyRequiredToOperate(Math.min(this.energyToOpen, max), this.keepAlive);
    }

    public EnergyRequiredToOperate update(EnergyRequiredToOperate updated) {
        this.keepAlive = updated.keepAlive;
        this.energyToOpen = updated.energyToOpen;
        return this;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("keepAlive", this.keepAlive);
        compound.m_128405_("energyToOpen", this.energyToOpen);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.keepAlive = compound.m_128451_("keepAlive");
        this.energyToOpen = compound.m_128451_("energyToOpen");
    }
}

