/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.power.general;

import dev.tauri.jsg.api.config.JSGConfig;
import dev.tauri.jsg.api.power.JSGEnergyStorage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class SmallEnergyStorage
extends JSGEnergyStorage
implements INBTSerializable<Tag> {
    public SmallEnergyStorage() {
        super(JSGConfig.Stargate.stargateEnergyStorage.get() / 4, JSGConfig.Stargate.stargateMaxEnergyTransfer.get(), 0);
    }

    public SmallEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    public SmallEnergyStorage(int capacity) {
        super(capacity, JSGConfig.Stargate.stargateMaxEnergyTransfer.get());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.m_128405_("energy", this.energy);
        return tagCompound;
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)nbt;
            this.deserializeNBT(tag);
        }
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt != null && nbt.m_128441_("energy")) {
            this.energy = nbt.m_128451_("energy");
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = super.receiveEnergy(maxReceive, simulate);
        if (energyReceived > 0) {
            this.onEnergyChanged();
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!simulate) {
            this.energy -= maxExtract;
            if (this.energy < 0) {
                this.energy = 0;
            }
            this.onEnergyChanged();
        } else if (maxExtract > this.energy) {
            maxExtract = this.energy;
        }
        return maxExtract;
    }

    public int receiveEnergyInternal(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate && energyReceived > 0) {
            this.energy += energyReceived;
            this.onEnergyChanged();
        }
        return energyReceived;
    }
}

