/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.power.zpm;

import dev.tauri.jsg.api.power.zpm.IEnergyStorageZPM;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public class ZPMEnergyStorage
implements IEnergyStorageZPM,
INBTSerializable<CompoundTag> {
    protected long energy;
    protected long capacity;
    public int maxReceive;
    public int maxExtract;

    public ZPMEnergyStorage(long capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0);
    }

    public ZPMEnergyStorage(long capacity, int maxReceive, int maxExtract, int energy) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = Math.max(0L, Math.min(capacity, (long)energy));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.m_128356_("energy", this.energy);
        return tagCompound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt != null) {
            if (nbt.m_128441_("energy")) {
                this.energy = nbt.m_128451_("energy");
            }
            if (nbt.m_128441_("longEnergy")) {
                this.energy = nbt.m_128454_("longEnergy");
            }
        }
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        if (!simulate) {
            this.energy -= (long)maxExtract;
            if (this.energy < 0L) {
                this.energy = 0L;
            }
            this.onEnergyChanged();
        } else if ((long)maxExtract > this.energy) {
            maxExtract = (int)this.energy;
        }
        return maxExtract;
    }

    @Override
    public long getEnergyStored() {
        return this.energy;
    }

    @Override
    public long getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public boolean canExtract() {
        return true;
    }

    @Override
    public boolean canReceive() {
        return false;
    }

    public void setEnergyStored(long energyStored) {
        this.energy = Math.min(energyStored, this.capacity);
        this.onEnergyChanged();
    }

    protected void onEnergyChanged() {
    }
}

