/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.raycaster.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.tauri.jsg.api.stargate.network.address.symbol.types.AbstractSymbolType;
import dev.tauri.jsg.api.util.I18n;
import dev.tauri.jsg.api.util.Localizable;
import dev.tauri.jsg.api.util.vectors.Vector3f;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RayCastedButton {
    public final List<Vector3f> vectors = new ArrayList<Vector3f>();
    public final int buttonId;
    @Nullable
    public final Localizable titleLocalization;

    public RayCastedButton(int buttonId, List<Vector3f> vectors) {
        this(buttonId, (Localizable)null, vectors, false);
    }

    public RayCastedButton(int buttonId, List<Vector3f> vectors, boolean correctXYZ) {
        this(buttonId, (Localizable)null, vectors, correctXYZ);
    }

    public RayCastedButton(int buttonId, @NotNull AbstractSymbolType<?> symbolType, List<Vector3f> vectors) {
        this(buttonId, (Localizable)symbolType.valueOf(buttonId), vectors, false);
    }

    public RayCastedButton(int buttonId, @NotNull String titleLocalization, List<Vector3f> vectors) {
        this(buttonId, titleLocalization, vectors, false);
    }

    public RayCastedButton(int buttonId, @Nullable Localizable titleLocalization, List<Vector3f> vectors) {
        this(buttonId, titleLocalization, vectors, false);
    }

    public RayCastedButton(int buttonId, @NotNull String titleLocalization, List<Vector3f> vectors, boolean correctXYZ) {
        this(buttonId, () -> I18n.format(titleLocalization), vectors, correctXYZ);
    }

    public RayCastedButton(int buttonId, @Nullable Localizable titleLocalization, List<Vector3f> vectors, boolean correctXYZ) {
        this.titleLocalization = titleLocalization;
        this.buttonId = buttonId;
        this.vectors.addAll(vectors);
        if (correctXYZ) {
            this.vectors.clear();
            for (Vector3f v : vectors) {
                this.vectors.add(new Vector3f(v.getX(), -v.getZ(), v.getY()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack stack) {
        stack.m_85836_();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix = stack.m_85850_().m_252922_();
        Tesselator t = Tesselator.m_85913_();
        BufferBuilder b = t.m_85915_();
        b.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        for (Vector3f vertex : this.vectors) {
            b.m_252986_(matrix, vertex.x, vertex.z, -vertex.y).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        }
        b.m_252986_(matrix, this.vectors.get((int)0).x, this.vectors.get((int)0).z, -this.vectors.get((int)0).y).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        t.m_85914_();
        stack.m_85849_();
    }

    @NotNull
    public Vector3f getTitlePos() {
        if (this.vectors.isEmpty()) {
            return new Vector3f();
        }
        Vector3f vector = new Vector3f(0.0f, Float.MIN_VALUE, 0.0f);
        for (Vector3f v : this.vectors) {
            if (v.z > vector.y) {
                vector.y = v.z;
            }
            vector.x += v.x;
            vector.z -= v.y;
        }
        vector.x /= (float)this.vectors.size();
        vector.z /= (float)this.vectors.size();
        return vector;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTitle(float rotation, PoseStack stack, MultiBufferSource bufferSource) {
        if (this.titleLocalization == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        String titleComponent = this.titleLocalization.localize();
        Vector3f titlePos = this.getTitlePos();
        stack.m_85836_();
        stack.m_252880_(titlePos.getX(), titlePos.getY() + 0.1f, titlePos.getZ());
        stack.m_252781_(Axis.f_252436_.m_252977_(-rotation));
        stack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        stack.m_85837_(0.0, 0.0, -0.1);
        float scale = 0.2f;
        stack.m_85841_(-0.025f * scale, -0.025f * scale, 0.025f * scale);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        float backgroundOpacityConfig = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int backgroundOpacity = (int)(backgroundOpacityConfig * 255.0f) << 24;
        Font font = Minecraft.m_91087_().f_91062_;
        float x = -font.m_92895_(titleComponent) / 2;
        font.m_271703_(titleComponent, x, 0.0f, 0x20FFFFFF, false, matrix4f, bufferSource, Font.DisplayMode.SEE_THROUGH, backgroundOpacity, 0xF000F0);
        font.m_271703_(titleComponent, x, 0.0f, -1, false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        stack.m_85849_();
    }
}

