/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.registry;

import dev.tauri.jsg.api.helper.BlockHelper;
import dev.tauri.jsg.api.util.TagFetcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;

public class BiomeOverlayRegistry {
    private static final Map<ResourceLocation, BiomeOverlayInstance> INSTANCES = new HashMap<ResourceLocation, BiomeOverlayInstance>();
    public static final BiomeOverlayInstance NORMAL = new BiomeOverlayInstance("normal", ChatFormatting.GRAY);
    public static final BiomeOverlayInstance FROST = new BiomeOverlayInstance("frost", ChatFormatting.DARK_AQUA);
    public static final BiomeOverlayInstance MOSSY = new BiomeOverlayInstance("mossy", ChatFormatting.DARK_GREEN);
    public static final BiomeOverlayInstance AGED = new BiomeOverlayInstance("aged", ChatFormatting.GRAY);
    public static final BiomeOverlayInstance SOOTY = new BiomeOverlayInstance("sooty", ChatFormatting.DARK_GRAY);

    @NotNull
    public static BiomeOverlayInstance getBiomeOverlayByItem(ItemStack stack) {
        return Objects.requireNonNull(BiomeOverlayRegistry.getBiomeOverlayByItem(stack, false));
    }

    public static BiomeOverlayInstance getBiomeOverlayByItem(ItemStack stack, boolean canBeNull) {
        for (BiomeOverlayInstance overlay : INSTANCES.values()) {
            if (!stack.m_204117_(overlay.overlayItems)) continue;
            return overlay;
        }
        return canBeNull ? null : NORMAL;
    }

    @NotNull
    public static BiomeOverlayInstance getBiomeOverlayByBiome(Holder<Biome> biome) {
        for (BiomeOverlayInstance overlay : INSTANCES.values()) {
            if (!biome.m_203656_(overlay.overlayBiomes)) continue;
            return overlay;
        }
        return NORMAL;
    }

    @NotNull
    public static List<BiomeOverlayInstance> values() {
        return new ArrayList<BiomeOverlayInstance>(INSTANCES.values());
    }

    @NotNull
    public static BiomeOverlayInstance getUpdatedBiomeOverlay(Level world, BlockPos topmostBlock, List<BiomeOverlayInstance> supportedOverlays) {
        BiomeOverlayInstance ret = BiomeOverlayRegistry.getBiomeOverlayByBlockPos(world, topmostBlock);
        if (supportedOverlays.contains(ret)) {
            return ret;
        }
        return NORMAL;
    }

    @NotNull
    public static BiomeOverlayInstance getBiomeOverlayByBlockPos(Level world, BlockPos topmostBlock) {
        return BiomeOverlayRegistry.getBiomeOverlayByBlockPos(world, topmostBlock, true);
    }

    @NotNull
    public static BiomeOverlayInstance getBiomeOverlayByBlockPos(Level world, BlockPos topmostBlock, boolean checkUnderSky) {
        Holder biome = world.m_204166_(topmostBlock);
        if (checkUnderSky && world.m_46472_() != Level.f_46429_ && !BlockHelper.isBlockDirectlyUnderSky(world, topmostBlock)) {
            return NORMAL;
        }
        if (((Biome)biome.m_203334_()).m_198904_(topmostBlock)) {
            return FROST;
        }
        return BiomeOverlayRegistry.getBiomeOverlayByBiome((Holder<Biome>)biome);
    }

    @NotNull
    public static BiomeOverlayInstance byId(ResourceLocation id) {
        return INSTANCES.getOrDefault(id, NORMAL);
    }

    public static class BiomeOverlayInstance {
        public final TagKey<Item> overlayItems;
        public final TagKey<Biome> overlayBiomes;
        public final String suffix;
        public final ChatFormatting color;
        public final String unlocalizedName;
        public final ResourceLocation id;

        private BiomeOverlayInstance(String name, ChatFormatting color) {
            this(new ResourceLocation("jsg", name), color);
        }

        public BiomeOverlayInstance(ResourceLocation id, ChatFormatting color) {
            this.id = id;
            this.suffix = id.m_135815_().equalsIgnoreCase("normal") ? "" : "_" + id.m_135815_().toLowerCase();
            this.unlocalizedName = "gui.biome_overlay." + id.m_135815_().toLowerCase();
            this.color = color;
            this.overlayItems = ItemTags.create((ResourceLocation)new ResourceLocation(id.m_135827_(), "biome_overlay/" + id.m_135815_().toLowerCase()));
            this.overlayBiomes = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(id.m_135827_(), "biome_overlay/" + id.m_135815_().toLowerCase()));
            INSTANCES.put(id, this);
        }

        public List<Item> getOverlayItems() {
            return TagFetcher.getItemsInTag(this.overlayItems);
        }

        public String getLocalizedColorizedName() {
            return String.valueOf(this.color) + I18n.m_118938_((String)this.unlocalizedName, (Object[])new Object[0]);
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

